/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.pubmed;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.SearchEngineBaseDescriptor;
import org.carrot2.source.SimpleSearchEngineDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;
import org.carrot2.util.httpclient.HttpRedirectStrategy;

public final class PubMedDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.pubmed.PubMedDocumentSource";
    public final String prefix = "PubMedDocumentSource";
    public final String title = "Performs searches on the PubMed database using its on-line e-utilities: http://eutils.ncbi.nlm.nih.gov/entrez/query/static/eutils_help.html";
    public final String label = "";
    public final String description = "";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(PubMedDocumentSourceDescriptor.attributes.maxResults);
        hashSet.add(PubMedDocumentSourceDescriptor.attributes.redirectStrategy);
        hashSet.add(PubMedDocumentSourceDescriptor.attributes.toolName);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(PubMedDocumentSourceDescriptor.attributes.maxResults);
        hashSet2.add(PubMedDocumentSourceDescriptor.attributes.redirectStrategy);
        hashSet2.add(PubMedDocumentSourceDescriptor.attributes.toolName);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.compressed);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.documents);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.query);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.results);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.start);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "PubMedDocumentSource";
    }

    public String getTitle() {
        return "Performs searches on the PubMed database using its on-line e-utilities: http://eutils.ncbi.nlm.nih.gov/entrez/query/static/eutils_help.html";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder
    extends SimpleSearchEngineDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder maxResults(int n) {
            this.map.put("PubMedDocumentSource.maxResults", n);
            return this;
        }

        public AttributeBuilder maxResults(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("PubMedDocumentSource.maxResults", iObjectFactory);
            return this;
        }

        public AttributeBuilder redirectStrategy(HttpRedirectStrategy httpRedirectStrategy) {
            this.map.put("PubMedDocumentSource.redirectStrategy", httpRedirectStrategy);
            return this;
        }

        public AttributeBuilder redirectStrategy(Class<?> clazz) {
            this.map.put("PubMedDocumentSource.redirectStrategy", clazz);
            return this;
        }

        public AttributeBuilder redirectStrategy(IObjectFactory<? extends HttpRedirectStrategy> iObjectFactory) {
            this.map.put("PubMedDocumentSource.redirectStrategy", iObjectFactory);
            return this;
        }

        public AttributeBuilder toolName(String string) {
            this.map.put("PubMedDocumentSource.toolName", string);
            return this;
        }

        public AttributeBuilder toolName(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("PubMedDocumentSource.toolName", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo maxResults = new AttributeInfo("PubMedDocumentSource.maxResults", "org.carrot2.source.pubmed.PubMedDocumentSource", "maxResults", "Maximum results to fetch. No more than the specified number of results\nwill be fetched from PubMed, regardless of the requested number of results.", "Maximum results", "Maximum results to fetch", "No more than the specified number of results will be fetched from PubMed, regardless of the requested number of results.", "Search query", AttributeLevel.ADVANCED, null);
        public final AttributeInfo redirectStrategy = new AttributeInfo("PubMedDocumentSource.redirectStrategy", "org.carrot2.source.pubmed.PubMedDocumentSource", "redirectStrategy", "HTTP redirect response strategy (follow or throw an error).", "HTTP redirect strategy", "HTTP redirect response strategy (follow or throw an error)", null, "Service", AttributeLevel.MEDIUM, null);
        public final AttributeInfo toolName = new AttributeInfo("PubMedDocumentSource.toolName", "org.carrot2.source.pubmed.PubMedDocumentSource", "toolName", "Tool name, if registered.", "EUtils Registered Tool Name", "Tool name, if registered", null, "Search query", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends SimpleSearchEngineDescriptor.Keys {
        public static final String MAX_RESULTS = "PubMedDocumentSource.maxResults";
        public static final String REDIRECT_STRATEGY = "PubMedDocumentSource.redirectStrategy";
        public static final String TOOL_NAME = "PubMedDocumentSource.toolName";

        protected Keys() {
        }
    }
}

