/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.pubmed;

import com.google.common.collect.Lists;
import java.util.List;
import org.carrot2.source.pubmed.PathTrackingHandler;
import org.xml.sax.SAXException;

class PubMedIdSearchHandler
extends PathTrackingHandler {
    private List<String> pubMedPrimaryIds;
    private long matchCount;

    public PubMedIdSearchHandler() {
        super.addTrigger("/eSearchResult/Count", new PathTrackingHandler.Trigger(this){

            @Override
            public void afterElement(String string, String string2, String string3) {
                PubMedIdSearchHandler.this.matchCount = Long.parseLong(string3);
            }
        });
        super.addTrigger("/eSearchResult/IdList/Id", new PathTrackingHandler.Trigger(this){

            @Override
            public void afterElement(String string, String string2, String string3) {
                PubMedIdSearchHandler.this.pubMedPrimaryIds.add(string3);
            }
        });
    }

    @Override
    public void startDocument() throws SAXException {
        this.matchCount = -1L;
        this.pubMedPrimaryIds = Lists.newArrayList();
    }

    public List<String> getPubMedPrimaryIds() {
        return this.pubMedPrimaryIds;
    }

    public long getMatchCount() {
        return this.matchCount;
    }
}

