/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.opensearch;

import com.google.common.collect.Maps;
import com.sun.syndication.fetcher.FeedFetcher;
import com.sun.syndication.fetcher.impl.HttpURLFeedFetcher;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngine;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.opensearch.RomeFetcherUtils;
import org.carrot2.util.StringUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.IntRange;
import org.carrot2.util.resource.URLResourceWithParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable(prefix="OpenSearchDocumentSource")
public class OpenSearchDocumentSource
extends MultipageSearchEngine {
    static final Logger logger = LoggerFactory.getLogger(OpenSearchDocumentSource.class);
    private static final int MAX_CONCURRENT_THREADS = 10;
    @Input
    @Processing
    @Init
    @Attribute
    @Required
    @Label(value="Feed URL template")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    public String feedUrlTemplate;
    @Input
    @Processing
    @Init
    @Attribute
    @Required
    @IntRange(min=1)
    @Label(value="Results per page")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    public int resultsPerPage = 50;
    @Input
    @Processing
    @Init
    @Attribute
    @IntRange(min=1)
    @Label(value="Maximum results")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    public int maximumResults = 1000;
    @Input
    @Init
    @Processing
    @Attribute
    @Label(value="Feed URL parameters")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public Map<String, String> feedUrlParams = null;
    @Input
    @Init
    @Processing
    @Attribute
    @Label(value="User agent")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public String userAgent = null;
    private MultipageSearchEngineMetadata metadata;
    private FeedFetcher feedFetcher;
    private static final String SEARCH_TERMS_VARIABLE_NAME = "searchTerms";
    private static final String START_INDEX_VARIABLE_NAME = "startIndex";
    private static final String START_PAGE_VARIABLE_NAME = "startPage";
    private static final String COUNT_VARIABLE_NAME = "count";

    public void beforeProcessing() {
        boolean bl;
        boolean bl2 = URLResourceWithParams.containsAttributePlaceholder((String)this.feedUrlTemplate, (String)START_PAGE_VARIABLE_NAME);
        if (!(bl2 ^ (bl = URLResourceWithParams.containsAttributePlaceholder((String)this.feedUrlTemplate, (String)START_INDEX_VARIABLE_NAME)))) {
            throw new ProcessingException("The feedUrlTemplate must contain either " + URLResourceWithParams.formatAttributePlaceholder((String)START_INDEX_VARIABLE_NAME) + " or " + URLResourceWithParams.formatAttributePlaceholder((String)START_PAGE_VARIABLE_NAME) + " variable");
        }
        if (!URLResourceWithParams.containsAttributePlaceholder((String)this.feedUrlTemplate, (String)SEARCH_TERMS_VARIABLE_NAME)) {
            throw new ProcessingException("The feedUrlTemplate must contain " + URLResourceWithParams.formatAttributePlaceholder((String)SEARCH_TERMS_VARIABLE_NAME) + " variable");
        }
        if (this.resultsPerPage == 0) {
            throw new ProcessingException("resultsPerPage must be set");
        }
        this.metadata = new MultipageSearchEngineMetadata(this.resultsPerPage, this.maximumResults, bl2);
        this.feedFetcher = new HttpURLFeedFetcher();
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.userAgent)) {
            this.feedFetcher.setUserAgent(this.userAgent);
        }
    }

    public void process() throws ProcessingException {
        super.process(this.metadata, this.getSharedExecutor(10, ((Object)((Object)this)).getClass()));
    }

    protected Callable<SearchEngineResponse> createFetcher(final MultipageSearchEngine.SearchRange searchRange) {
        return new MultipageSearchEngine.SearchEngineResponseCallable(this){

            public SearchEngineResponse search() throws Exception {
                HashMap hashMap = Maps.newHashMap();
                hashMap.put(OpenSearchDocumentSource.SEARCH_TERMS_VARIABLE_NAME, OpenSearchDocumentSource.this.query);
                hashMap.put(OpenSearchDocumentSource.START_INDEX_VARIABLE_NAME, searchRange.start + 1);
                hashMap.put(OpenSearchDocumentSource.START_PAGE_VARIABLE_NAME, searchRange.start + 1);
                hashMap.put(OpenSearchDocumentSource.COUNT_VARIABLE_NAME, searchRange.results);
                StringBuilder stringBuilder = new StringBuilder(URLResourceWithParams.substituteAttributes((String)OpenSearchDocumentSource.this.feedUrlTemplate, (Map)hashMap));
                if (OpenSearchDocumentSource.this.feedUrlParams != null) {
                    for (Map.Entry<String, String> object2 : OpenSearchDocumentSource.this.feedUrlParams.entrySet()) {
                        stringBuilder.append('&');
                        stringBuilder.append(object2.getKey());
                        stringBuilder.append('=');
                        stringBuilder.append(StringUtils.urlEncodeWrapException((String)object2.getValue(), (String)"UTF-8"));
                    }
                }
                String string = stringBuilder.toString();
                logger.debug("Fetching URL: " + string);
                return RomeFetcherUtils.fetchUrl(string, OpenSearchDocumentSource.this.feedFetcher);
            }
        };
    }
}

