/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.opensearch;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.MultipageSearchEngineDescriptor;
import org.carrot2.source.SearchEngineBaseDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class OpenSearchDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.opensearch.OpenSearchDocumentSource";
    public final String prefix = "OpenSearchDocumentSource";
    public final String title = "A <code>IDocumentSource</code> fetching <code>Document</code>s (search results) from an OpenSearch feed";
    public final String label = "";
    public final String description = "<p> Based on code donated by Julien Nioche.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(OpenSearchDocumentSourceDescriptor.attributes.feedUrlParams);
        hashSet.add(OpenSearchDocumentSourceDescriptor.attributes.feedUrlTemplate);
        hashSet.add(OpenSearchDocumentSourceDescriptor.attributes.maximumResults);
        hashSet.add(OpenSearchDocumentSourceDescriptor.attributes.resultsPerPage);
        hashSet.add(OpenSearchDocumentSourceDescriptor.attributes.userAgent);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(OpenSearchDocumentSourceDescriptor.attributes.feedUrlParams);
        hashSet2.add(OpenSearchDocumentSourceDescriptor.attributes.feedUrlTemplate);
        hashSet2.add(OpenSearchDocumentSourceDescriptor.attributes.maximumResults);
        hashSet2.add(OpenSearchDocumentSourceDescriptor.attributes.resultsPerPage);
        hashSet2.add(OpenSearchDocumentSourceDescriptor.attributes.userAgent);
        hashSet2.add(MultipageSearchEngineDescriptor.attributes.searchMode);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.compressed);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.documents);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.query);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.results);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.start);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "OpenSearchDocumentSource";
    }

    public String getTitle() {
        return "A <code>IDocumentSource</code> fetching <code>Document</code>s (search results) from an OpenSearch feed";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "<p> Based on code donated by Julien Nioche.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder
    extends MultipageSearchEngineDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder feedUrlParams(Map<String, String> map) {
            this.map.put("OpenSearchDocumentSource.feedUrlParams", map);
            return this;
        }

        public AttributeBuilder feedUrlParams(IObjectFactory<? extends Map<String, String>> iObjectFactory) {
            this.map.put("OpenSearchDocumentSource.feedUrlParams", iObjectFactory);
            return this;
        }

        public AttributeBuilder feedUrlTemplate(String string) {
            this.map.put("OpenSearchDocumentSource.feedUrlTemplate", string);
            return this;
        }

        public AttributeBuilder feedUrlTemplate(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("OpenSearchDocumentSource.feedUrlTemplate", iObjectFactory);
            return this;
        }

        public AttributeBuilder maximumResults(int n) {
            this.map.put("OpenSearchDocumentSource.maximumResults", n);
            return this;
        }

        public AttributeBuilder maximumResults(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("OpenSearchDocumentSource.maximumResults", iObjectFactory);
            return this;
        }

        public AttributeBuilder resultsPerPage(int n) {
            this.map.put("OpenSearchDocumentSource.resultsPerPage", n);
            return this;
        }

        public AttributeBuilder resultsPerPage(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("OpenSearchDocumentSource.resultsPerPage", iObjectFactory);
            return this;
        }

        public AttributeBuilder userAgent(String string) {
            this.map.put("OpenSearchDocumentSource.userAgent", string);
            return this;
        }

        public AttributeBuilder userAgent(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("OpenSearchDocumentSource.userAgent", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo feedUrlParams = new AttributeInfo("OpenSearchDocumentSource.feedUrlParams", "org.carrot2.source.opensearch.OpenSearchDocumentSource", "feedUrlParams", "Additional parameters to be appended to {@link org.carrot2.source.opensearch.OpenSearchDocumentSource#feedUrlTemplate} on each request.", "Feed URL parameters", "Additional parameters to be appended to <code>org.carrot2.source.opensearch.OpenSearchDocumentSource.feedUrlTemplate</code> on each request", null, "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo feedUrlTemplate = new AttributeInfo("OpenSearchDocumentSource.feedUrlTemplate", "org.carrot2.source.opensearch.OpenSearchDocumentSource", "feedUrlTemplate", "URL to fetch the search feed from. The URL template can contain variable place\nholders as defined by the OpenSearch specification that will be replaced during\nruntime. The format of the place holder is <code>${variable}</code>. The following\nvariables are supported:\n<ul>\n<li><code>searchTerms</code> will be replaced by the query</li>\n<li><code>startIndex</code> index of the first result to be searched. Mutually \nexclusive with <code>startPage</code></li>\n<li><code>startPage</code> index of the first result\nto be searched. Mutually exclusive with <code>startIndex</code>.</li>\n<li><code>count</code> the number of search results per page</li>\n</ul>\n\n<p>Example URL feed templates for public services:</p>\n<dl>\n<dt>nature.com</dt>\n<dd><code>http://www.nature.com/opensearch/request?interface=opensearch&amp;operation=searchRetrieve&amp;query=${searchTerms}&amp;startRecord=${startIndex}&amp;maximumRecords=${count}&amp;httpAccept=application/rss%2Bxml</code></dd>\n<dt>indeed.com</dt>\n<dd><code>http://www.indeed.com/opensearch?q=${searchTerms}&amp;start=${startIndex}&amp;limit=${count}</code></dd>\n</dl>", "Feed URL template", "URL to fetch the search feed from", "The URL template can contain variable place holders as defined by the OpenSearch specification that will be replaced during runtime. The format of the place holder is <code>${variable}</code>. The following variables are supported: <ul> <li><code>searchTerms</code> will be replaced by the query</li> <li><code>startIndex</code> index of the first result to be searched. Mutually exclusive with <code>startPage</code></li> <li><code>startPage</code> index of the first result to be searched. Mutually exclusive with <code>startIndex</code>.</li> <li><code>count</code> the number of search results per page</li> </ul> <p>Example URL feed templates for public services:</p> <dl> <dt>nature.com</dt> <dd><code>http://www.nature.com/opensearch/request?interface=opensearch&amp;operation=searchRetrieve&amp;query=${searchTerms}&amp;startRecord=${startIndex}&amp;maximumRecords=${count}&amp;httpAccept=application/rss%2Bxml</code></dd> <dt>indeed.com</dt> <dd><code>http://www.indeed.com/opensearch?q=${searchTerms}&amp;start=${startIndex}&amp;limit=${count}</code></dd> </dl>", "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo maximumResults = new AttributeInfo("OpenSearchDocumentSource.maximumResults", "org.carrot2.source.opensearch.OpenSearchDocumentSource", "maximumResults", "Maximum number of results. The maximum number of results the document source can\ndeliver.", "Maximum results", "Maximum number of results", "The maximum number of results the document source can deliver.", "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo resultsPerPage = new AttributeInfo("OpenSearchDocumentSource.resultsPerPage", "org.carrot2.source.opensearch.OpenSearchDocumentSource", "resultsPerPage", "Results per page. The number of results per page the document source will expect\nthe feed to return.", "Results per page", "Results per page", "The number of results per page the document source will expect the feed to return.", "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo userAgent = new AttributeInfo("OpenSearchDocumentSource.userAgent", "org.carrot2.source.opensearch.OpenSearchDocumentSource", "userAgent", "User agent header. The contents of the User-Agent HTTP header to use when making\nrequests to the feed URL. If empty or <code>null</code> value is provided,\nthe following User-Agent will be sent: <code>Rome Client (http://tinyurl.com/64t5n) \nVer: UNKNOWN</code>.", "User agent", "User agent header", "The contents of the User-Agent HTTP header to use when making requests to the feed URL. If empty or <code>null</code> value is provided, the following User-Agent will be sent: <code>Rome Client (http://tinyurl.com/64t5n) Ver: UNKNOWN</code>.", "Service", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends MultipageSearchEngineDescriptor.Keys {
        public static final String FEED_URL_PARAMS = "OpenSearchDocumentSource.feedUrlParams";
        public static final String FEED_URL_TEMPLATE = "OpenSearchDocumentSource.feedUrlTemplate";
        public static final String MAXIMUM_RESULTS = "OpenSearchDocumentSource.maximumResults";
        public static final String RESULTS_PER_PAGE = "OpenSearchDocumentSource.resultsPerPage";
        public static final String USER_AGENT = "OpenSearchDocumentSource.userAgent";

        protected Keys() {
        }
    }
}

