/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.solr;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.ProcessingResult;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.xml.RemoteXmlSimpleSearchEngineBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.carrot2.util.resource.ClassLoaderResource;
import org.carrot2.util.resource.ClassResource;
import org.carrot2.util.resource.FileResource;
import org.carrot2.util.resource.IResource;

@Bindable(prefix="SolrDocumentSource")
public class SolrDocumentSource
extends RemoteXmlSimpleSearchEngineBase {
    protected static final String FIELD_MAPPING = "Index field mapping";
    @Input
    @Processing
    @Attribute
    @Label(value="Service URL")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public String serviceUrlBase = "http://localhost:8983/solr/select";
    @Input
    @Init
    @Processing
    @Attribute
    @Label(value="Filter query")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Service")
    public String solrFilterQuery = "";
    @Input
    @Processing
    @Attribute
    @Label(value="Title field name")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Index field mapping")
    public String solrTitleFieldName = "title";
    @Input
    @Processing
    @Attribute
    @Label(value="Summary field name")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Index field mapping")
    public String solrSummaryFieldName = "description";
    @Input
    @Processing
    @Attribute
    @Label(value="URL field name")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Index field mapping")
    public String solrUrlFieldName = "url";
    @Input
    @Processing
    @Attribute
    @Label(value="ID field name")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Index field mapping")
    public String solrIdFieldName;
    @Input
    @Init
    @Attribute
    @Label(value="Custom XSLT adapter from Solr to Carrot2 format")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Index field mapping")
    @ImplementingClasses(classes={ClassLoaderResource.class, FileResource.class}, strict=false)
    public IResource solrXsltAdapter;
    @Input
    @Init
    @Processing
    @Attribute
    @Label(value="Read Solr clusters if present")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Index field mapping")
    public boolean readClusters = false;
    @Input
    @Init
    @Processing
    @Attribute
    @Label(value="Use highlighter output if present")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Index field mapping")
    public boolean useHighlighterOutput = true;
    @Input
    @Init
    @Processing
    @Attribute
    @Label(value="Copy Solr document fields")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Index field mapping")
    public boolean copyFields = false;
    @Processing
    @Input
    @Output
    @Internal
    @Attribute(key="clusters")
    @Label(value="Clusters")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Search result information")
    public List<Cluster> clusters;

    protected void afterFetch(SearchEngineResponse searchEngineResponse, ProcessingResult processingResult) {
        if (this.readClusters) {
            final HashSet hashSet = Sets.newHashSet();
            List<Document> list = processingResult.getDocuments();
            if (list == null) {
                list = Collections.emptyList();
            }
            List list2 = processingResult.getClusters();
            if (list != null && list2 != null) {
                Object object22;
                for (Object object22 : list) {
                    hashSet.add(object22.getStringId());
                }
                object22 = new Predicate<Document>(){

                    public boolean apply(Document document) {
                        return document != null && hashSet.contains(document.getStringId());
                    }
                };
                this.clusters = SolrDocumentSource.sanityCheck(list2, (Predicate<Document>)object22);
            }
        }
    }

    protected String buildServiceUrl() {
        return String.valueOf(this.serviceUrlBase) + (this.serviceUrlBase.contains("?") ? "&" : "?") + "q=" + SolrDocumentSource.urlEncode((String)this.query) + (Strings.isNullOrEmpty((String)this.solrFilterQuery) ? "" : "&fq=" + SolrDocumentSource.urlEncode((String)this.solrFilterQuery)) + "&start=" + this.start + "&rows=" + this.results + "&indent=off";
    }

    protected IResource getXsltResource() {
        if (this.solrXsltAdapter == null) {
            return new ClassResource(SolrDocumentSource.class, "solr-to-c2.xsl");
        }
        return this.solrXsltAdapter;
    }

    protected Map<String, String> getXsltParameters() {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("solr.title-field", this.solrTitleFieldName);
        hashMap.put("solr.summary-field", this.solrSummaryFieldName);
        hashMap.put("solr.url-field", this.solrUrlFieldName);
        hashMap.put("solr.id-field", Strings.nullToEmpty((String)this.solrIdFieldName));
        hashMap.put("solr.use-highlighter-output", this.useHighlighterOutput ? "true" : "false");
        hashMap.put("solr.copy-fields", this.copyFields ? "true" : "false");
        return hashMap;
    }

    private static List<Cluster> sanityCheck(List<Cluster> list, Predicate<Document> predicate) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        for (Cluster cluster : list) {
            Cluster cluster2 = new Cluster();
            cluster2.addPhrases((Iterable)cluster.getPhrases());
            cluster2.addDocuments(Iterables.filter((Iterable)cluster.getDocuments(), predicate));
            cluster2.addSubclusters(SolrDocumentSource.sanityCheck(cluster.getSubclusters(), predicate));
            arrayList.add(cluster2);
        }
        return arrayList;
    }
}

