/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.solr;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.source.SearchEngineBaseDescriptor;
import org.carrot2.source.xml.RemoteXmlSimpleSearchEngineBaseDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;
import org.carrot2.util.resource.IResource;

public final class SolrDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.solr.SolrDocumentSource";
    public final String prefix = "SolrDocumentSource";
    public final String title = "Fetches documents from an instance of Solr";
    public final String label = "";
    public final String description = "";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(SolrDocumentSourceDescriptor.attributes.clusters);
        hashSet.add(SolrDocumentSourceDescriptor.attributes.copyFields);
        hashSet.add(SolrDocumentSourceDescriptor.attributes.readClusters);
        hashSet.add(SolrDocumentSourceDescriptor.attributes.serviceUrlBase);
        hashSet.add(SolrDocumentSourceDescriptor.attributes.solrFilterQuery);
        hashSet.add(SolrDocumentSourceDescriptor.attributes.solrIdFieldName);
        hashSet.add(SolrDocumentSourceDescriptor.attributes.solrSummaryFieldName);
        hashSet.add(SolrDocumentSourceDescriptor.attributes.solrTitleFieldName);
        hashSet.add(SolrDocumentSourceDescriptor.attributes.solrUrlFieldName);
        hashSet.add(SolrDocumentSourceDescriptor.attributes.solrXsltAdapter);
        hashSet.add(SolrDocumentSourceDescriptor.attributes.useHighlighterOutput);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(SolrDocumentSourceDescriptor.attributes.clusters);
        hashSet2.add(SolrDocumentSourceDescriptor.attributes.copyFields);
        hashSet2.add(SolrDocumentSourceDescriptor.attributes.readClusters);
        hashSet2.add(SolrDocumentSourceDescriptor.attributes.serviceUrlBase);
        hashSet2.add(SolrDocumentSourceDescriptor.attributes.solrFilterQuery);
        hashSet2.add(SolrDocumentSourceDescriptor.attributes.solrIdFieldName);
        hashSet2.add(SolrDocumentSourceDescriptor.attributes.solrSummaryFieldName);
        hashSet2.add(SolrDocumentSourceDescriptor.attributes.solrTitleFieldName);
        hashSet2.add(SolrDocumentSourceDescriptor.attributes.solrUrlFieldName);
        hashSet2.add(SolrDocumentSourceDescriptor.attributes.solrXsltAdapter);
        hashSet2.add(SolrDocumentSourceDescriptor.attributes.useHighlighterOutput);
        hashSet2.add(RemoteXmlSimpleSearchEngineBaseDescriptor.attributes.redirectStrategy);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.compressed);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.documents);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.query);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.results);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.start);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "SolrDocumentSource";
    }

    public String getTitle() {
        return "Fetches documents from an instance of Solr";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder
    extends RemoteXmlSimpleSearchEngineBaseDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder clusters(List<Cluster> list) {
            this.map.put("clusters", list);
            return this;
        }

        public AttributeBuilder clusters(IObjectFactory<? extends List<Cluster>> iObjectFactory) {
            this.map.put("clusters", iObjectFactory);
            return this;
        }

        public List<Cluster> clusters() {
            return (List)this.map.get("clusters");
        }

        public AttributeBuilder copyFields(boolean bl) {
            this.map.put("SolrDocumentSource.copyFields", bl);
            return this;
        }

        public AttributeBuilder copyFields(IObjectFactory<? extends Boolean> iObjectFactory) {
            this.map.put("SolrDocumentSource.copyFields", iObjectFactory);
            return this;
        }

        public AttributeBuilder readClusters(boolean bl) {
            this.map.put("SolrDocumentSource.readClusters", bl);
            return this;
        }

        public AttributeBuilder readClusters(IObjectFactory<? extends Boolean> iObjectFactory) {
            this.map.put("SolrDocumentSource.readClusters", iObjectFactory);
            return this;
        }

        public AttributeBuilder serviceUrlBase(String string) {
            this.map.put("SolrDocumentSource.serviceUrlBase", string);
            return this;
        }

        public AttributeBuilder serviceUrlBase(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("SolrDocumentSource.serviceUrlBase", iObjectFactory);
            return this;
        }

        public AttributeBuilder solrFilterQuery(String string) {
            this.map.put("SolrDocumentSource.solrFilterQuery", string);
            return this;
        }

        public AttributeBuilder solrFilterQuery(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("SolrDocumentSource.solrFilterQuery", iObjectFactory);
            return this;
        }

        public AttributeBuilder solrIdFieldName(String string) {
            this.map.put("SolrDocumentSource.solrIdFieldName", string);
            return this;
        }

        public AttributeBuilder solrIdFieldName(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("SolrDocumentSource.solrIdFieldName", iObjectFactory);
            return this;
        }

        public AttributeBuilder solrSummaryFieldName(String string) {
            this.map.put("SolrDocumentSource.solrSummaryFieldName", string);
            return this;
        }

        public AttributeBuilder solrSummaryFieldName(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("SolrDocumentSource.solrSummaryFieldName", iObjectFactory);
            return this;
        }

        public AttributeBuilder solrTitleFieldName(String string) {
            this.map.put("SolrDocumentSource.solrTitleFieldName", string);
            return this;
        }

        public AttributeBuilder solrTitleFieldName(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("SolrDocumentSource.solrTitleFieldName", iObjectFactory);
            return this;
        }

        public AttributeBuilder solrUrlFieldName(String string) {
            this.map.put("SolrDocumentSource.solrUrlFieldName", string);
            return this;
        }

        public AttributeBuilder solrUrlFieldName(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("SolrDocumentSource.solrUrlFieldName", iObjectFactory);
            return this;
        }

        public AttributeBuilder solrXsltAdapter(IResource iResource) {
            this.map.put("SolrDocumentSource.solrXsltAdapter", iResource);
            return this;
        }

        public AttributeBuilder solrXsltAdapter(Class<?> clazz) {
            this.map.put("SolrDocumentSource.solrXsltAdapter", clazz);
            return this;
        }

        public AttributeBuilder solrXsltAdapter(IObjectFactory<? extends IResource> iObjectFactory) {
            this.map.put("SolrDocumentSource.solrXsltAdapter", iObjectFactory);
            return this;
        }

        public AttributeBuilder useHighlighterOutput(boolean bl) {
            this.map.put("SolrDocumentSource.useHighlighterOutput", bl);
            return this;
        }

        public AttributeBuilder useHighlighterOutput(IObjectFactory<? extends Boolean> iObjectFactory) {
            this.map.put("SolrDocumentSource.useHighlighterOutput", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo clusters = new AttributeInfo("clusters", "org.carrot2.source.solr.SolrDocumentSource", "clusters", "If {@link org.carrot2.source.solr.SolrDocumentSource#readClusters} is <code>true</code> and clusters are present in the input\nXML, they will be deserialized and exposed to components further down the processing\nchain.", "Clusters", "If <code>org.carrot2.source.solr.SolrDocumentSource.readClusters</code> is <code>true</code> and clusters are present in the input XML, they will be deserialized and exposed to components further down the processing chain", null, "Search result information", AttributeLevel.BASIC, null);
        public final AttributeInfo copyFields = new AttributeInfo("SolrDocumentSource.copyFields", "org.carrot2.source.solr.SolrDocumentSource", "copyFields", "Copy Solr fields from the search result to Carrot2 {@link org.carrot2.core.Document} instances (as fields).", "Copy Solr document fields", "Copy Solr fields from the search result to Carrot2 <code>org.carrot2.core.Document</code> instances (as fields)", null, "Index field mapping", AttributeLevel.ADVANCED, null);
        public final AttributeInfo readClusters = new AttributeInfo("SolrDocumentSource.readClusters", "org.carrot2.source.solr.SolrDocumentSource", "readClusters", "If clusters are present in the Solr output they will be read and exposed to components\nfurther down the processing chain. Note that {@link org.carrot2.source.solr.SolrDocumentSource#solrIdFieldName} is required to match\ndocument references.", "Read Solr clusters if present", "If clusters are present in the Solr output they will be read and exposed to components further down the processing chain", "Note that <code>org.carrot2.source.solr.SolrDocumentSource.solrIdFieldName</code> is required to match document references.", "Index field mapping", AttributeLevel.BASIC, null);
        public final AttributeInfo serviceUrlBase = new AttributeInfo("SolrDocumentSource.serviceUrlBase", "org.carrot2.source.solr.SolrDocumentSource", "serviceUrlBase", "Solr service URL base. The URL base can contain additional Solr parameters, \nfor example: <tt>http://localhost:8983/solr/select?fq=timestemp:[NOW-24HOUR TO NOW]</tt>", "Service URL", "Solr service URL base", "The URL base can contain additional Solr parameters, for example: <tt>http://localhost:8983/solr/select?fq=timestemp:[NOW-24HOUR TO NOW]</tt>", "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo solrFilterQuery = new AttributeInfo("SolrDocumentSource.solrFilterQuery", "org.carrot2.source.solr.SolrDocumentSource", "solrFilterQuery", "Filter query appended to {@link org.carrot2.source.solr.SolrDocumentSource#serviceUrlBase}.", "Filter query", "Filter query appended to <code>org.carrot2.source.solr.SolrDocumentSource.serviceUrlBase</code>", null, "Service", AttributeLevel.MEDIUM, null);
        public final AttributeInfo solrIdFieldName = new AttributeInfo("SolrDocumentSource.solrIdFieldName", "org.carrot2.source.solr.SolrDocumentSource", "solrIdFieldName", "Document identifier field name (specified in Solr schema). This field is necessary\nto connect Solr-side clusters or highlighter output to documents.", "ID field name", "Document identifier field name (specified in Solr schema)", "This field is necessary to connect Solr-side clusters or highlighter output to documents.", "Index field mapping", AttributeLevel.MEDIUM, null);
        public final AttributeInfo solrSummaryFieldName = new AttributeInfo("SolrDocumentSource.solrSummaryFieldName", "org.carrot2.source.solr.SolrDocumentSource", "solrSummaryFieldName", "Summary field name. Name of the Solr field that will provide document summary.", "Summary field name", "Summary field name", "Name of the Solr field that will provide document summary.", "Index field mapping", AttributeLevel.MEDIUM, null);
        public final AttributeInfo solrTitleFieldName = new AttributeInfo("SolrDocumentSource.solrTitleFieldName", "org.carrot2.source.solr.SolrDocumentSource", "solrTitleFieldName", "Title field name. Name of the Solr field that will provide document titles.", "Title field name", "Title field name", "Name of the Solr field that will provide document titles.", "Index field mapping", AttributeLevel.MEDIUM, null);
        public final AttributeInfo solrUrlFieldName = new AttributeInfo("SolrDocumentSource.solrUrlFieldName", "org.carrot2.source.solr.SolrDocumentSource", "solrUrlFieldName", "URL field name. Name of the Solr field that will provide document URLs.", "URL field name", "URL field name", "Name of the Solr field that will provide document URLs.", "Index field mapping", AttributeLevel.MEDIUM, null);
        public final AttributeInfo solrXsltAdapter = new AttributeInfo("SolrDocumentSource.solrXsltAdapter", "org.carrot2.source.solr.SolrDocumentSource", "solrXsltAdapter", "Provides a custom XSLT stylesheet for converting from Solr's output to\nan XML format <a href=\"http://download.carrot2.org/head/manual/index.html#section.architecture.xml-formats\">\nparsed by Carrot2</a>. For performance reasons this attribute\ncan be provided at initialization time only (no processing-time overrides).", "Custom XSLT adapter from Solr to Carrot2 format", "Provides a custom XSLT stylesheet for converting from Solr's output to an XML format <a href=\"http://download.carrot2.org/head/manual/index.html.section.architecture.xml-formats\"> parsed by Carrot2</a>", "For performance reasons this attribute can be provided at initialization time only (no processing-time overrides).", "Index field mapping", AttributeLevel.ADVANCED, null);
        public final AttributeInfo useHighlighterOutput = new AttributeInfo("SolrDocumentSource.useHighlighterOutput", "org.carrot2.source.solr.SolrDocumentSource", "useHighlighterOutput", "If highlighter fragments are present in the Solr output they will be used (and preferred) over full\nfield content. This may be used to decrease the memory required for clustering. In general if highlighter\nis used the contents of full fields won't be emitted from Solr though (because it makes little sense).\n\n<p>Setting this option to <code>false</code> will disable using the highlighter output\nentirely.</p>", "Use highlighter output if present", "If highlighter fragments are present in the Solr output they will be used (and preferred) over full field content", "This may be used to decrease the memory required for clustering. In general if highlighter is used the contents of full fields won't be emitted from Solr though (because it makes little sense). <p>Setting this option to <code>false</code> will disable using the highlighter output entirely.</p>", "Index field mapping", AttributeLevel.BASIC, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends RemoteXmlSimpleSearchEngineBaseDescriptor.Keys {
        public static final String CLUSTERS = "clusters";
        public static final String COPY_FIELDS = "SolrDocumentSource.copyFields";
        public static final String READ_CLUSTERS = "SolrDocumentSource.readClusters";
        public static final String SERVICE_URL_BASE = "SolrDocumentSource.serviceUrlBase";
        public static final String SOLR_FILTER_QUERY = "SolrDocumentSource.solrFilterQuery";
        public static final String SOLR_ID_FIELD_NAME = "SolrDocumentSource.solrIdFieldName";
        public static final String SOLR_SUMMARY_FIELD_NAME = "SolrDocumentSource.solrSummaryFieldName";
        public static final String SOLR_TITLE_FIELD_NAME = "SolrDocumentSource.solrTitleFieldName";
        public static final String SOLR_URL_FIELD_NAME = "SolrDocumentSource.solrUrlFieldName";
        public static final String SOLR_XSLT_ADAPTER = "SolrDocumentSource.solrXsltAdapter";
        public static final String USE_HIGHLIGHTER_OUTPUT = "SolrDocumentSource.useHighlighterOutput";

        protected Keys() {
        }
    }
}

