/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.google;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.carrot2.core.Document;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngine;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.httpclient.HttpRedirectStrategy;
import org.carrot2.util.httpclient.HttpUtils;

@Bindable(prefix="GoogleDocumentSource")
public class GoogleDocumentSource
extends MultipageSearchEngine {
    @Input
    @Processing
    @Internal
    @Attribute
    @Label(value="Service URL")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public String serviceUrl = "http://ajax.googleapis.com/ajax/services/search/web";
    @Input
    @Processing
    @Internal
    @Attribute
    @Label(value="Referrer")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public String referer = "http://www.carrot2.org";
    @Input
    @Processing
    @Attribute
    @Label(value="Keep highlights")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Postprocessing")
    public boolean keepHighlights = false;
    @Input
    @Processing
    @Attribute
    @Label(value="HTTP redirect strategy")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Service")
    @Internal
    public HttpRedirectStrategy redirectStrategy = HttpRedirectStrategy.NO_REDIRECTS;
    static final MultipageSearchEngineMetadata metadata = new MultipageSearchEngineMetadata(8, 32);
    private static final int MAX_CONCURRENT_THREADS = 10;

    public void process() throws ProcessingException {
        super.process(metadata, this.getSharedExecutor(10, ((Object)((Object)this)).getClass()));
    }

    protected Callable<SearchEngineResponse> createFetcher(final MultipageSearchEngine.SearchRange searchRange) {
        return new MultipageSearchEngine.SearchEngineResponseCallable(this){

            public SearchEngineResponse search() throws Exception {
                JsonNode jsonNode5;
                SearchEngineResponse searchEngineResponse = new SearchEngineResponse();
                NameValuePair[] nameValuePairArray = new NameValuePair[]{new BasicNameValuePair("v", "1.0"), new BasicNameValuePair("rsz", "large"), new BasicNameValuePair("start", Integer.toString(searchRange.start)), new BasicNameValuePair("q", GoogleDocumentSource.this.query)};
                Header[] headerArray = new Header[]{new BasicHeader("Referer", GoogleDocumentSource.this.referer)};
                ObjectMapper objectMapper = new ObjectMapper();
                HttpUtils.Response response = HttpUtils.doGET((String)GoogleDocumentSource.this.serviceUrl, Arrays.asList(nameValuePairArray), Arrays.asList(headerArray), null, null, (int)8000, (RedirectStrategy)GoogleDocumentSource.this.redirectStrategy.value());
                JsonNode jsonNode2 = objectMapper.readTree(response.getPayloadAsStream());
                if (jsonNode2 == null) {
                    return searchEngineResponse;
                }
                JsonNode jsonNode3 = jsonNode2.get("responseData");
                if (jsonNode3 == null) {
                    return searchEngineResponse;
                }
                JsonNode jsonNode4 = jsonNode3.get("results");
                if (jsonNode4 == null) {
                    return searchEngineResponse;
                }
                for (JsonNode jsonNode5 : jsonNode4) {
                    Document document = new Document(jsonNode5.get("titleNoFormatting").textValue(), jsonNode5.get("content").textValue(), jsonNode5.get("url").textValue());
                    searchEngineResponse.results.add(document);
                }
                jsonNode5 = jsonNode3.get("cursor");
                if (jsonNode5 == null) {
                    return searchEngineResponse;
                }
                Iterator iterator = jsonNode5.get("estimatedResultCount");
                if (iterator != null) {
                    searchEngineResponse.metadata.put("resultsTotal", Long.parseLong(iterator.textValue()));
                } else {
                    searchEngineResponse.metadata.put("resultsTotal", 0L);
                }
                searchEngineResponse.metadata.put("compression", response.compression);
                return searchEngineResponse;
            }
        };
    }

    protected void afterFetch(SearchEngineResponse searchEngineResponse) {
        GoogleDocumentSource.clean((SearchEngineResponse)searchEngineResponse, (boolean)this.keepHighlights, (String[])new String[]{"title", "snippet"});
        for (Document document : searchEngineResponse.results) {
            String string = (String)document.getField("url");
            if (string == null) continue;
            try {
                document.setField("url", (Object)URLDecoder.decode(string, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw ExceptionUtils.wrapAsRuntimeException((Throwable)unsupportedEncodingException);
            }
        }
    }
}

