/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.google;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.MultipageSearchEngineDescriptor;
import org.carrot2.source.SearchEngineBaseDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;
import org.carrot2.util.httpclient.HttpRedirectStrategy;

public final class GoogleDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.google.GoogleDocumentSource";
    public final String prefix = "GoogleDocumentSource";
    public final String title = "A <code>IDocumentSource</code> fetching search results from Google JSON API";
    public final String label = "";
    public final String description = "Please note that this document source cannot deliver more than 32 search results.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(GoogleDocumentSourceDescriptor.attributes.keepHighlights);
        hashSet.add(GoogleDocumentSourceDescriptor.attributes.redirectStrategy);
        hashSet.add(GoogleDocumentSourceDescriptor.attributes.referer);
        hashSet.add(GoogleDocumentSourceDescriptor.attributes.serviceUrl);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(GoogleDocumentSourceDescriptor.attributes.keepHighlights);
        hashSet2.add(GoogleDocumentSourceDescriptor.attributes.redirectStrategy);
        hashSet2.add(GoogleDocumentSourceDescriptor.attributes.referer);
        hashSet2.add(GoogleDocumentSourceDescriptor.attributes.serviceUrl);
        hashSet2.add(MultipageSearchEngineDescriptor.attributes.searchMode);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.compressed);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.documents);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.query);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.results);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.start);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "GoogleDocumentSource";
    }

    public String getTitle() {
        return "A <code>IDocumentSource</code> fetching search results from Google JSON API";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "Please note that this document source cannot deliver more than 32 search results.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder
    extends MultipageSearchEngineDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder keepHighlights(boolean bl) {
            this.map.put("GoogleDocumentSource.keepHighlights", bl);
            return this;
        }

        public AttributeBuilder keepHighlights(IObjectFactory<? extends Boolean> iObjectFactory) {
            this.map.put("GoogleDocumentSource.keepHighlights", iObjectFactory);
            return this;
        }

        public AttributeBuilder redirectStrategy(HttpRedirectStrategy httpRedirectStrategy) {
            this.map.put("GoogleDocumentSource.redirectStrategy", httpRedirectStrategy);
            return this;
        }

        public AttributeBuilder redirectStrategy(Class<?> clazz) {
            this.map.put("GoogleDocumentSource.redirectStrategy", clazz);
            return this;
        }

        public AttributeBuilder redirectStrategy(IObjectFactory<? extends HttpRedirectStrategy> iObjectFactory) {
            this.map.put("GoogleDocumentSource.redirectStrategy", iObjectFactory);
            return this;
        }

        public AttributeBuilder referer(String string) {
            this.map.put("GoogleDocumentSource.referer", string);
            return this;
        }

        public AttributeBuilder referer(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("GoogleDocumentSource.referer", iObjectFactory);
            return this;
        }

        public AttributeBuilder serviceUrl(String string) {
            this.map.put("GoogleDocumentSource.serviceUrl", string);
            return this;
        }

        public AttributeBuilder serviceUrl(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("GoogleDocumentSource.serviceUrl", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo keepHighlights = new AttributeInfo("GoogleDocumentSource.keepHighlights", "org.carrot2.source.google.GoogleDocumentSource", "keepHighlights", "Keep query word highlighting. Google by default highlights query words in snippets\nusing the bold HTML tag. Set this attribute to <code>true</code> to keep these\nhighlights.", "Keep highlights", "Keep query word highlighting", "Google by default highlights query words in snippets using the bold HTML tag. Set this attribute to <code>true</code> to keep these highlights.", "Postprocessing", AttributeLevel.ADVANCED, null);
        public final AttributeInfo redirectStrategy = new AttributeInfo("GoogleDocumentSource.redirectStrategy", "org.carrot2.source.google.GoogleDocumentSource", "redirectStrategy", "HTTP redirect response strategy (follow or throw an error).", "HTTP redirect strategy", "HTTP redirect response strategy (follow or throw an error)", null, "Service", AttributeLevel.MEDIUM, null);
        public final AttributeInfo referer = new AttributeInfo("GoogleDocumentSource.referer", "org.carrot2.source.google.GoogleDocumentSource", "referer", "Request referrer. Please do not use the default value when deploying this\ncomponent in production environments. Instead, put the URL to your application\nhere.", "Referrer", "Request referrer", "Please do not use the default value when deploying this component in production environments. Instead, put the URL to your application here.", "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo serviceUrl = new AttributeInfo("GoogleDocumentSource.serviceUrl", "org.carrot2.source.google.GoogleDocumentSource", "serviceUrl", "Service URL. Google web search service URL.", "Service URL", "Service URL", "Google web search service URL.", "Service", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends MultipageSearchEngineDescriptor.Keys {
        public static final String KEEP_HIGHLIGHTS = "GoogleDocumentSource.keepHighlights";
        public static final String REDIRECT_STRATEGY = "GoogleDocumentSource.redirectStrategy";
        public static final String REFERER = "GoogleDocumentSource.referer";
        public static final String SERVICE_URL = "GoogleDocumentSource.serviceUrl";

        protected Keys() {
        }
    }
}

