/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors.impl;

import java.io.File;
import java.util.Map;
import org.carrot2.workbench.core.helpers.DisposeBin;
import org.carrot2.workbench.core.helpers.GUIFactory;
import org.carrot2.workbench.editors.AttributeEditorAdapter;
import org.carrot2.workbench.editors.AttributeEditorInfo;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.IAttributeEditor;
import org.carrot2.workbench.editors.impl.EditorsPlugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DirectoryEditor
extends AttributeEditorAdapter {
    public static final String PREF_LAST_SELECTED_DIR = "directory-editor.last-selected-dir";
    private DisposeBin disposeBin = new DisposeBin();
    private Text dirLocation;
    private File current = null;

    protected AttributeEditorInfo init(Map<String, Object> map) {
        return new AttributeEditorInfo(1, false);
    }

    public void createEditor(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)GUIFactory.editorGridData().grab(true, false).span(n, 1).create());
        GridLayout gridLayout = GUIFactory.zeroMarginGridLayout();
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 3;
        composite2.setLayout((Layout)gridLayout);
        this.createTextBox(composite2);
        this.createFileButton(composite2);
        this.createClearButton(composite2);
    }

    private void createTextBox(Composite composite) {
        this.dirLocation = new Text(composite, 526348);
        GridData gridData = GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).align(4, 0x1000000).create();
        this.dirLocation.setLayoutData((Object)gridData);
    }

    private void createFileButton(Composite composite) {
        Image image = EditorsPlugin.getImageDescriptor("icons/open_folder.gif").createImage();
        this.disposeBin.add(new Resource[]{image});
        Button button = new Button(composite, 0x1000008);
        button.setImage(image);
        button.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).create());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryEditor.this.openIndexDialog();
            }
        });
    }

    private void createClearButton(Composite composite) {
        Image image = EditorsPlugin.getImageDescriptor("icons/clear.gif").createImage();
        this.disposeBin.add(new Resource[]{image});
        Button button = new Button(composite, 0x1000008);
        button.setImage(image);
        button.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).create());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryEditor.this.setValue(null);
            }
        });
    }

    private void openIndexDialog() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.dirLocation.getShell());
        if (this.current != null) {
            directoryDialog.setFilterPath(this.current.getAbsolutePath());
        } else {
            directoryDialog.setFilterPath(EditorsPlugin.getDefault().getPreferenceStore().getString(PREF_LAST_SELECTED_DIR));
        }
        String string = directoryDialog.open();
        if (string != null) {
            File file = new File(string);
            EditorsPlugin.getDefault().getPreferenceStore().setValue(PREF_LAST_SELECTED_DIR, file.getAbsolutePath());
            this.setValue(file);
        }
    }

    public void setValue(Object object) {
        if (object == this.current) {
            return;
        }
        if (object != null && !(object instanceof File)) {
            return;
        }
        if (object == null) {
            this.current = null;
            this.dirLocation.setText("");
        } else {
            this.current = (File)object;
            this.dirLocation.setText(this.current.getAbsolutePath());
        }
        this.fireAttributeChanged(new AttributeEvent((IAttributeEditor)this));
    }

    public Object getValue() {
        return this.current;
    }

    public void dispose() {
        this.disposeBin.dispose();
    }
}

