/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors.impl;

import com.google.common.collect.BiMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.carrot2.workbench.core.helpers.GUIFactory;
import org.carrot2.workbench.editors.AttributeEditorAdapter;
import org.carrot2.workbench.editors.AttributeEditorInfo;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.IAttributeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class MappedValueComboEditor
extends AttributeEditorAdapter {
    private static final String NULL_VALUE = "";
    private BiMap<? extends Object, String> valueToName;
    private List<Object> valueOrder;
    private Composite boxContainer;
    private Combo box;
    private Object currentValue;
    public boolean valueRequired = true;
    public boolean anyValueAllowed = false;

    protected AttributeEditorInfo init(Map<String, Object> map) {
        return new AttributeEditorInfo(1, false);
    }

    protected final void setMappedValues(BiMap<? extends Object, String> biMap, List<Object> list) {
        this.valueToName = biMap;
        this.valueOrder = list;
        if (this.box != null) {
            Object object = this.getValue();
            this.recreate();
            this.setValue(object);
        }
    }

    public void createEditor(Composite composite, int n) {
        this.boxContainer = new Composite(composite, 0);
        this.boxContainer.setLayoutData((Object)GUIFactory.editorGridData().grab(true, false).hint(200, -1).align(4, 0x1000000).span(n, 1).create());
        this.boxContainer.setLayout((Layout)new FillLayout());
        this.recreate();
    }

    private void recreate() {
        if (this.box != null) {
            this.box.dispose();
        }
        int n = 0x804 | (this.anyValueAllowed ? 0 : 8);
        this.box = new Combo(this.boxContainer, n);
        final Class<?> clazz = ((Object)((Object)this)).getClass();
        this.box.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MappedValueComboEditor.this.checkContentChange();
            }
        });
        this.box.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (MappedValueComboEditor.this.anyValueAllowed) {
                    MappedValueComboEditor.this.fireContentChanging(new AttributeEvent((Object)clazz, MappedValueComboEditor.this.getAttributeKey(), MappedValueComboEditor.this.getBoxValue()));
                } else {
                    MappedValueComboEditor.this.checkContentChange();
                }
            }
        });
        this.box.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    MappedValueComboEditor.this.checkContentChange();
                }
            }
        });
        if (!this.valueRequired) {
            this.box.add(NULL_VALUE);
        }
        for (Object object : this.valueOrder) {
            this.box.add((String)this.valueToName.get(object));
        }
        this.boxContainer.layout(true);
        this.currentValue = null;
    }

    private Object userFriendlyToValue(String string) {
        if (string == NULL_VALUE || StringUtils.isEmpty((String)string)) {
            return null;
        }
        Object object = this.valueToName.inverse().get((Object)string);
        if (object == null && this.anyValueAllowed) {
            object = string;
        }
        return object;
    }

    private Object getBoxValue() {
        int n = this.box.getSelectionIndex();
        if (n > 0) {
            if (n == 0 && !this.valueRequired) {
                return null;
            }
            if (!this.valueRequired) {
                --n;
            }
            return this.valueOrder.get(n);
        }
        String string = this.box.getText();
        return this.userFriendlyToValue(string);
    }

    public void setFocus() {
        this.box.setFocus();
    }

    public Object getValue() {
        return this.currentValue;
    }

    public void setValue(Object object) {
        if (ObjectUtils.equals((Object)object, (Object)this.getValue())) {
            return;
        }
        if (object == null) {
            this.box.deselectAll();
        } else {
            String string = (String)this.valueToName.get(object);
            if (string != null) {
                this.box.setText(string);
            } else if (this.anyValueAllowed) {
                this.box.setText(object.toString());
            } else {
                this.box.deselectAll();
            }
        }
        this.checkContentChange();
    }

    private void checkContentChange() {
        Object object = this.getBoxValue();
        if (!ObjectUtils.equals((Object)this.currentValue, (Object)object)) {
            this.currentValue = object;
            this.fireAttributeChanged(new AttributeEvent((IAttributeEditor)this));
        }
    }
}

