/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors.impl;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.carrot2.util.attribute.constraint.ResourceNameFilter;
import org.carrot2.util.attribute.constraint.ResourceNameFilters;
import org.carrot2.util.resource.FileResource;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.URLResource;
import org.carrot2.util.resource.URLResourceWithParams;
import org.carrot2.workbench.core.helpers.DisposeBin;
import org.carrot2.workbench.core.helpers.GUIFactory;
import org.carrot2.workbench.editors.AttributeEditorAdapter;
import org.carrot2.workbench.editors.AttributeEditorInfo;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.IAttributeEditor;
import org.carrot2.workbench.editors.impl.EditorsPlugin;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ResourceEditor
extends AttributeEditorAdapter {
    private DisposeBin disposeBin = new DisposeBin();
    private Text resourceInfo;
    private IResource resource = null;
    private ResourceNameFilter[] filters;
    private static final IInputValidator validatorURI = new IInputValidator(){

        public String isValid(String string) {
            try {
                URL uRL = new URL(string);
                if (uRL.getProtocol() == null) {
                    throw new MalformedURLException("Empty scheme.");
                }
            }
            catch (MalformedURLException malformedURLException) {
                return "Not a valid URL";
            }
            return null;
        }
    };

    protected AttributeEditorInfo init(Map<String, Object> map) {
        if (this.descriptor.getAnnotation(ResourceNameFilters.class) != null) {
            this.filters = ((ResourceNameFilters)this.descriptor.getAnnotation(ResourceNameFilters.class)).filters();
        }
        return new AttributeEditorInfo(1, false);
    }

    public void createEditor(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)GUIFactory.editorGridData().grab(true, false).span(n, 1).create());
        GridLayout gridLayout = GUIFactory.zeroMarginGridLayout();
        gridLayout.numColumns = 4;
        gridLayout.horizontalSpacing = 3;
        composite2.setLayout((Layout)gridLayout);
        this.createTextBox(composite2);
        this.createFileButton(composite2);
        this.createUrlButton(composite2);
        this.createClearButton(composite2);
    }

    private void createTextBox(Composite composite) {
        this.resourceInfo = new Text(composite, 526348);
        GridData gridData = GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).align(4, 0x1000000).create();
        this.resourceInfo.setLayoutData((Object)gridData);
    }

    private void createClearButton(Composite composite) {
        Image image = EditorsPlugin.getImageDescriptor("icons/clear.gif").createImage();
        this.disposeBin.add(new Resource[]{image});
        Button button = new Button(composite, 0x1000008);
        button.setImage(image);
        button.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).create());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceEditor.this.setValue(null);
            }
        });
    }

    private void createFileButton(Composite composite) {
        Image image = EditorsPlugin.getImageDescriptor("icons/open_folder.gif").createImage();
        this.disposeBin.add(new Resource[]{image});
        Button button = new Button(composite, 0x1000008);
        button.setImage(image);
        button.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).create());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceEditor.this.openFileResourceDialog();
            }
        });
    }

    private void openFileResourceDialog() {
        Object object;
        FileDialog fileDialog = new FileDialog(this.resourceInfo.getShell());
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        if (this.filters != null) {
            ResourceNameFilter[] resourceNameFilterArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                object = resourceNameFilterArray[n2];
                arrayList.add(object.pattern());
                arrayList2.add(object.description());
                ++n2;
            }
        } else {
            arrayList.addAll(Arrays.asList("*.xml;*.XML", "*.*"));
            arrayList2.addAll(Arrays.asList("XML files", "All"));
        }
        fileDialog.setFilterExtensions(arrayList.toArray(new String[arrayList.size()]));
        fileDialog.setFilterNames(arrayList2.toArray(new String[arrayList2.size()]));
        if (this.resource != null && this.resource instanceof FileResource) {
            fileDialog.setFileName(((FileResource)this.resource).getFile().getAbsolutePath());
        } else {
            fileDialog.setFileName(EditorsPlugin.getDefault().getPreferenceStore().getString("resource-editor.last-selected-file"));
        }
        object = fileDialog.open();
        if (object != null) {
            File file = new File((String)object);
            EditorsPlugin.getDefault().getPreferenceStore().setValue("resource-editor.last-selected-file", file.getAbsolutePath());
            this.setValue(new FileResource(file));
        }
    }

    private void createUrlButton(Composite composite) {
        Image image = EditorsPlugin.getImageDescriptor("icons/open_url.gif").createImage();
        this.disposeBin.add(new Resource[]{image});
        Button button = new Button(composite, 0x1000008);
        button.setImage(image);
        button.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceEditor.this.openURLResourceDialog();
            }
        });
    }

    private void openURLResourceDialog() {
        InputDialog inputDialog;
        String string = "";
        if (this.resource != null && this.resource instanceof URLResource) {
            string = ((URLResource)this.resource).getUrl().toExternalForm();
        }
        if (this.resource != null && this.resource instanceof URLResourceWithParams) {
            string = ((URLResourceWithParams)this.resource).getUrl().toExternalForm();
        }
        if ((inputDialog = new InputDialog(this.resourceInfo.getShell(), "Enter resource URL", "Enter resource URL", string, validatorURI)).open() == 0) {
            try {
                this.setValue(new URLResourceWithParams(new URL(inputDialog.getValue())));
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    public void setValue(Object object) {
        if (ObjectUtils.equals((Object)object, (Object)this.resource)) {
            return;
        }
        if (object != null && !(object instanceof IResource)) {
            return;
        }
        this.resource = (IResource)object;
        this.resourceInfo.setText(this.resource == null ? "" : this.resource.toString());
        this.fireAttributeChanged(new AttributeEvent((IAttributeEditor)this));
    }

    public Object getValue() {
        return this.resource;
    }

    public void dispose() {
        this.disposeBin.dispose();
    }
}

