/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors.impl;

import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.carrot2.workbench.core.helpers.GUIFactory;
import org.carrot2.workbench.editors.AttributeEditorAdapter;
import org.carrot2.workbench.editors.AttributeEditorInfo;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.IAttributeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class StringEditor
extends AttributeEditorAdapter {
    private Text textBox;
    private String content;

    protected AttributeEditorInfo init(Map<String, Object> map) {
        return new AttributeEditorInfo(1, false);
    }

    public void createEditor(Composite composite, int n) {
        this.textBox = this.createTextBox(composite, n);
        this.textBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                StringEditor.this.checkContentChange();
            }
        });
        this.textBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                StringEditor.this.fireContentChanging(new AttributeEvent((Object)StringEditor.this, StringEditor.this.getAttributeKey(), (Object)StringEditor.this.textBox.getText()));
            }
        });
        this.textBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    StringEditor.this.checkContentChange();
                }
            }
        });
        this.content = this.textBox.getText();
    }

    protected Text createTextBox(Composite composite, int n) {
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)GUIFactory.editorGridData().grab(true, false).hint(200, -1).align(4, 0x1000000).span(n, 1).create());
        return text;
    }

    public void setFocus() {
        this.textBox.setFocus();
    }

    public Object getValue() {
        return this.content;
    }

    public void setValue(Object object) {
        if (ObjectUtils.equals((Object)object, (Object)this.getValue())) {
            return;
        }
        this.textBox.setText(object == null ? "" : object.toString());
        this.checkContentChange();
    }

    private void checkContentChange() {
        String string = this.textBox.getText();
        if (!ObjectUtils.equals((Object)string, (Object)this.content) && this.isValid(string)) {
            this.content = string;
            this.fireAttributeChanged(new AttributeEvent((IAttributeEditor)this));
        }
    }

    protected boolean isValid(String string) {
        return true;
    }
}

