/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors.impl.numeric;

import java.util.Map;
import org.carrot2.util.RangeUtils;
import org.carrot2.util.attribute.constraint.DoubleRange;
import org.carrot2.workbench.editors.AttributeEditorInfo;
import org.carrot2.workbench.editors.impl.numeric.NumberUtils;
import org.carrot2.workbench.editors.impl.numeric.NumericRangeEditorBase;

class DoubleRangeEditor
extends NumericRangeEditorBase {
    private static final int EDITOR_PRECISION_DIGITS = 2;
    private DoubleRange constraint;

    public DoubleRangeEditor() {
        this(2);
    }

    public DoubleRangeEditor(int n) {
        super(n);
    }

    @Override
    public AttributeEditorInfo init(Map<String, Object> map) {
        this.constraint = NumberUtils.getDoubleRange(this.descriptor);
        double d = this.constraint.min();
        double d2 = this.constraint.max();
        double d3 = RangeUtils.getDoubleMinorTicks((double)d, (double)d2);
        double d4 = RangeUtils.getDoubleMajorTicks((double)d, (double)d2);
        this.setRanges(this.to_i(d), this.to_i(d2), this.to_i(d3), this.to_i(d4));
        return super.init(map);
    }

    public void setValue(Object object) {
        if (!(object instanceof Number)) {
            return;
        }
        super.propagateNewValue(this.to_i(((Number)object).doubleValue()));
    }

    @Override
    public Object getValue() {
        return this.to_d((Integer)super.getValue());
    }
}

