/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors.impl.numeric;

import java.lang.annotation.Annotation;
import java.text.NumberFormat;
import java.util.Locale;
import org.carrot2.util.attribute.AttributeDescriptor;
import org.carrot2.util.attribute.constraint.DoubleRange;
import org.carrot2.util.attribute.constraint.IntRange;

final class NumberUtils {
    private NumberUtils() {
    }

    public static boolean isUnbounded(DoubleRange doubleRange) {
        return Double.isInfinite(doubleRange.min()) || Double.isInfinite(doubleRange.max()) || Double.MIN_VALUE == doubleRange.min() || Double.MAX_VALUE == doubleRange.max();
    }

    public static boolean isUnbounded(IntRange intRange) {
        return Integer.MIN_VALUE == intRange.min() || Integer.MAX_VALUE == intRange.max();
    }

    public static DoubleRange getDoubleRange(AttributeDescriptor attributeDescriptor) {
        for (Annotation annotation : attributeDescriptor.constraints) {
            if (!(annotation instanceof DoubleRange)) continue;
            return (DoubleRange)annotation;
        }
        return null;
    }

    public static IntRange getIntRange(AttributeDescriptor attributeDescriptor) {
        for (Annotation annotation : attributeDescriptor.constraints) {
            if (!(annotation instanceof IntRange)) continue;
            return (IntRange)annotation;
        }
        return null;
    }

    public static String getTooltip(int n, int n2) {
        boolean bl;
        boolean bl2 = n == Integer.MIN_VALUE;
        boolean bl3 = bl = n2 == Integer.MAX_VALUE;
        if (!bl2 && !bl) {
            return "Valid range: unbounded integer";
        }
        return "Valid range: [" + NumberUtils.to_s(n) + "; " + NumberUtils.to_s(n2) + "]";
    }

    public static String getTooltip(double d, double d2) {
        boolean bl;
        boolean bl2 = Double.isInfinite(d) || d == Double.MIN_VALUE;
        boolean bl3 = bl = Double.isInfinite(d2) || d2 == Double.MAX_VALUE;
        if (!bl2 && !bl) {
            return "Valid range: unbounded";
        }
        return "Valid range: [" + NumberUtils.to_s(d) + "; " + NumberUtils.to_s(d2) + "]";
    }

    public static String to_s(int n) {
        if (n == Integer.MIN_VALUE) {
            return "-\u221e";
        }
        if (n == Integer.MAX_VALUE) {
            return "\u221e";
        }
        return Integer.toString(n);
    }

    public static String to_s(double d) {
        if (d == Double.MIN_VALUE || d == Double.NEGATIVE_INFINITY) {
            return "-\u221e";
        }
        if (d == Double.MAX_VALUE || d == Double.POSITIVE_INFINITY) {
            return "\u221e";
        }
        return NumberUtils.to_decimal(d);
    }

    public static String to_decimal(double d) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(4);
        return numberFormat.format(d);
    }
}

