/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors.impl.numeric;

import java.util.Map;
import org.carrot2.workbench.core.helpers.GUIFactory;
import org.carrot2.workbench.editors.AttributeEditorAdapter;
import org.carrot2.workbench.editors.AttributeEditorInfo;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.IAttributeEditor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;

abstract class NumericRangeEditorBase
extends AttributeEditorAdapter {
    private Scale scale;
    private Spinner spinner;
    private boolean duringSelection;
    private int min;
    private int max;
    private int precisionDigits;
    private int increment;
    private int pageIncrement;
    private boolean minBounded;
    private boolean maxBounded;
    private final double multiplier;
    private String tooltip;
    private int maxSpinnerWidth;
    private int currentValue;

    public NumericRangeEditorBase(int n) {
        this.precisionDigits = n;
        this.multiplier = Math.pow(10.0, n);
    }

    protected AttributeEditorInfo init(Map<String, Object> map) {
        return new AttributeEditorInfo(2, false);
    }

    protected final void setRanges(int n, int n2, int n3, int n4) {
        this.min = n;
        this.minBounded = n != Integer.MIN_VALUE;
        this.max = n2;
        this.maxBounded = n2 != Integer.MAX_VALUE;
        this.increment = n3;
        this.pageIncrement = n4;
        this.tooltip = !this.minBounded && !this.maxBounded ? "Valid range: unbounded" : "Valid range: [" + this.to_s(n) + "; " + this.to_s(n2) + "]";
    }

    public Object getValue() {
        return this.currentValue;
    }

    public void createEditor(Composite composite, int n) {
        GridDataFactory gridDataFactory = GUIFactory.editorGridData();
        GridData gridData = gridDataFactory.create();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 0x1000000;
        GridData gridData2 = gridDataFactory.span(n - 1, 1).grab(true, false).create();
        if (this.minBounded && this.maxBounded) {
            this.createScale(composite);
            this.scale.setLayoutData((Object)gridData2);
        } else {
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
        }
        this.createSpinner(composite);
        this.spinner.setSelection(this.spinner.getMaximum());
        gridData.widthHint = this.maxSpinnerWidth;
        gridData.horizontalAlignment = 4;
        this.spinner.setLayoutData((Object)gridData);
    }

    private void createScale(Composite composite) {
        this.scale = new Scale(composite, 256);
        this.scale.setMaximum(this.max);
        this.scale.setMinimum(this.min);
        this.scale.setIncrement(this.increment);
        this.scale.setPageIncrement(this.pageIncrement);
        this.scale.setToolTipText(this.tooltip);
        this.scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (NumericRangeEditorBase.this.scale.getSelection() != NumericRangeEditorBase.this.currentValue) {
                    NumericRangeEditorBase.this.propagateNewValue(NumericRangeEditorBase.this.scale.getSelection());
                }
            }
        });
        this.scale.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent mouseEvent) {
                if (NumericRangeEditorBase.this.scale.getSelection() != NumericRangeEditorBase.this.currentValue) {
                    NumericRangeEditorBase.this.propagateNewValue(NumericRangeEditorBase.this.scale.getSelection());
                }
            }
        });
    }

    private void createSpinner(Composite composite) {
        this.spinner = new Spinner(composite, 2048);
        this.spinner.setMaximum(1000);
        this.spinner.setMinimum(0);
        this.spinner.setDigits(2);
        this.maxSpinnerWidth = this.spinner.computeSize((int)-1, (int)-1).x;
        this.spinner.setMaximum(this.max);
        this.spinner.setMinimum(this.min);
        this.spinner.setSelection(this.min);
        this.spinner.setDigits(this.precisionDigits);
        this.spinner.setToolTipText(this.tooltip);
        if (this.minBounded && this.maxBounded) {
            this.spinner.setIncrement(this.increment);
            this.spinner.setPageIncrement(this.pageIncrement);
        }
        this.spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (NumericRangeEditorBase.this.currentValue != NumericRangeEditorBase.this.spinner.getSelection()) {
                    NumericRangeEditorBase.this.propagateNewValue(NumericRangeEditorBase.this.spinner.getSelection());
                }
            }
        });
    }

    protected final void propagateNewValue(int n) {
        if (!this.duringSelection) {
            this.duringSelection = true;
            this.currentValue = n;
            if (this.spinner != null && this.spinner.getSelection() != n) {
                this.spinner.setSelection(n);
            }
            if (this.scale != null && this.scale.getSelection() != n) {
                this.scale.setSelection(n);
            }
            this.duringSelection = false;
            this.fireAttributeChanged(new AttributeEvent((IAttributeEditor)this));
        }
    }

    protected final int to_i(double d) {
        if (d == Double.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (d == Double.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (Double.isNaN(d)) {
            return 0;
        }
        return (int)Math.round(d * this.multiplier);
    }

    protected final double to_d(int n) {
        return (double)n / this.multiplier;
    }

    private String to_s(int n) {
        if (n == Integer.MIN_VALUE) {
            return "-\u221e";
        }
        if (n == Integer.MAX_VALUE) {
            return "\u221e";
        }
        return String.format("%." + this.precisionDigits + "f", this.to_d(n));
    }
}

