/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors.impl.numeric;

import java.util.Map;
import java.util.regex.Pattern;
import org.carrot2.util.attribute.constraint.DoubleRange;
import org.carrot2.workbench.editors.AttributeEditorInfo;
import org.carrot2.workbench.editors.impl.numeric.NumberUtils;
import org.carrot2.workbench.editors.impl.numeric.UnboundedEditorBase;

final class UnboundedDoubleEditor
extends UnboundedEditorBase<Double> {
    private DoubleRange constraint;
    private static final Pattern pattern = Pattern.compile("[\\-]?[0-9]+[.]?[0-9]*");
    private static final Pattern temporaryPattern = Pattern.compile("[\\-]?[0-9]*");

    UnboundedDoubleEditor() {
    }

    @Override
    public AttributeEditorInfo init(Map<String, Object> map) {
        this.constraint = NumberUtils.getDoubleRange(this.descriptor);
        if (this.constraint != null) {
            this.min = this.constraint.min();
            this.max = this.constraint.max();
        } else {
            this.min = Double.MIN_VALUE;
            this.max = Double.MAX_VALUE;
        }
        this.pageIncrement = 1.0;
        this.tooltip = NumberUtils.getTooltip((Double)this.min, (Double)this.max);
        return super.init(map);
    }

    @Override
    protected String to_s(Number number) {
        return NumberUtils.to_decimal(number.doubleValue());
    }

    @Override
    protected void doPageIncrement(boolean bl) {
        if (this.getValue() == null) {
            this.setValue(0);
        } else {
            this.setValue(this.toRange((Double)this.getValue() + (bl ? (Double)this.pageIncrement : -((Double)this.pageIncrement).doubleValue())));
        }
    }

    @Override
    protected Double toRange(Double d) {
        if (d <= (Double)this.min) {
            d = (Double)this.min;
        }
        if (d >= (Double)this.max) {
            d = (Double)this.max;
        }
        return d;
    }

    @Override
    protected boolean isValid(String string) {
        if (string != null && pattern.matcher(string).matches()) {
            try {
                double d = this.to_v(string);
                if (d >= (Double)this.min && d <= (Double)this.max) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return false;
    }

    @Override
    protected Double to_v(String string) {
        return Double.parseDouble(string);
    }

    @Override
    protected boolean isValidForEditing(String string) {
        return this.isValid(string) || temporaryPattern.matcher(string).matches();
    }
}

