/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors.impl.numeric;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.carrot2.workbench.core.helpers.GUIFactory;
import org.carrot2.workbench.editors.AttributeEditorAdapter;
import org.carrot2.workbench.editors.AttributeEditorInfo;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.IAttributeEditor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

abstract class UnboundedEditorBase<T extends Number>
extends AttributeEditorAdapter {
    protected Text text;
    private T lastValidValue;
    private boolean duringSelection;
    protected String tooltip;
    protected T min;
    protected T max;
    protected T pageIncrement;

    UnboundedEditorBase() {
    }

    protected AttributeEditorInfo init(Map<String, Object> map) {
        return new AttributeEditorInfo(1, false);
    }

    public Object getValue() {
        return this.lastValidValue;
    }

    public void setValue(Object object) {
        if (object != null && object.equals(this.getValue())) {
            return;
        }
        if (object != null && !(object instanceof Number)) {
            return;
        }
        if (object == null) {
            this.propagateNewValue(null);
        } else {
            this.propagateNewValue(this.to_s((Number)object));
        }
    }

    public void createEditor(Composite composite, int n) {
        this.createText(composite, n);
    }

    private void createText(Composite composite, int n) {
        GridDataFactory gridDataFactory = GUIFactory.editorGridData();
        GridData gridData = gridDataFactory.create();
        gridData.horizontalSpan = n;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 0x1000000;
        this.text = new Text(composite, 18436);
        this.text.setLayoutData((Object)gridData);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (UnboundedEditorBase.this.isValid(UnboundedEditorBase.this.text.getText())) {
                    UnboundedEditorBase.this.propagateNewValue(UnboundedEditorBase.this.text.getText(), false);
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                UnboundedEditorBase.this.propagateNewValue(UnboundedEditorBase.this.to_s(UnboundedEditorBase.this.lastValidValue));
            }
        });
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                if (UnboundedEditorBase.this.duringSelection) {
                    return;
                }
                String string = UnboundedEditorBase.this.text.getText();
                String string2 = String.valueOf(string.substring(0, verifyEvent.start)) + verifyEvent.text + string.substring(verifyEvent.end);
                verifyEvent.doit = StringUtils.isEmpty((String)string2) || UnboundedEditorBase.this.isValidForEditing(string2);
            }
        });
        this.text.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
                if (UnboundedEditorBase.this.getValue() != null) {
                    UnboundedEditorBase.this.doPageIncrement(event.count > 0);
                }
            }
        });
        this.text.setToolTipText(this.tooltip);
    }

    protected final void propagateNewValue(String string) {
        this.propagateNewValue(string, true);
    }

    protected final void propagateNewValue(String string, boolean bl) {
        if (!this.duringSelection) {
            this.duringSelection = true;
            if (bl) {
                this.text.setText(string == null ? "" : string);
            }
            if (this.isValid(string)) {
                try {
                    this.lastValidValue = this.toRange(this.to_v(string));
                    this.fireAttributeChanged(new AttributeEvent((IAttributeEditor)this));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.duringSelection = false;
        }
    }

    protected abstract void doPageIncrement(boolean var1);

    protected abstract T toRange(T var1);

    protected abstract boolean isValid(String var1);

    protected abstract boolean isValidForEditing(String var1);

    protected abstract String to_s(Number var1);

    protected abstract T to_v(String var1);
}

