/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors.impl.numeric;

import java.util.Map;
import java.util.regex.Pattern;
import org.carrot2.util.attribute.constraint.IntRange;
import org.carrot2.workbench.editors.AttributeEditorInfo;
import org.carrot2.workbench.editors.impl.numeric.NumberUtils;
import org.carrot2.workbench.editors.impl.numeric.UnboundedEditorBase;

final class UnboundedIntegerEditor
extends UnboundedEditorBase<Integer> {
    private IntRange constraint;
    private static final Pattern pattern = Pattern.compile("[\\-]?[0-9]+");
    private static final Pattern temporaryPattern = Pattern.compile("[\\-]?[0-9]*");

    UnboundedIntegerEditor() {
    }

    @Override
    public AttributeEditorInfo init(Map<String, Object> map) {
        this.constraint = NumberUtils.getIntRange(this.descriptor);
        if (this.constraint != null) {
            this.min = this.constraint.min();
            this.max = this.constraint.max();
        } else {
            this.min = Integer.MIN_VALUE;
            this.max = Integer.MAX_VALUE;
        }
        this.pageIncrement = 1;
        this.tooltip = NumberUtils.getTooltip((Integer)this.min, (Integer)this.max);
        return super.init(map);
    }

    @Override
    protected String to_s(Number number) {
        return Integer.toString(number.intValue());
    }

    @Override
    protected void doPageIncrement(boolean bl) {
        if (this.getValue() == null) {
            this.setValue(0);
        } else {
            this.setValue(this.toRange((Integer)this.getValue() + (bl ? (Integer)this.pageIncrement : -((Integer)this.pageIncrement).intValue())));
        }
    }

    @Override
    protected Integer toRange(Integer n) {
        if (n <= (Integer)this.min) {
            n = (Integer)this.min;
        }
        if (n >= (Integer)this.max) {
            n = (Integer)this.max;
        }
        return n;
    }

    @Override
    protected boolean isValid(String string) {
        if (pattern.matcher(string).matches()) {
            try {
                double d = this.to_v(string).intValue();
                if (d >= (double)((Integer)this.min).intValue() && d <= (double)((Integer)this.max).intValue()) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return false;
    }

    @Override
    protected boolean isValidForEditing(String string) {
        return this.isValid(string) || temporaryPattern.matcher(string).matches();
    }

    @Override
    protected Integer to_v(String string) {
        return Integer.parseInt(string);
    }
}

