/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.vis;

import com.carrotsearch.hppc.IntStack;
import com.google.common.collect.Lists;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.Cluster;
import org.carrot2.core.ProcessingResult;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.helpers.PostponableJob;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.BrowserFacade;
import org.carrot2.workbench.core.ui.ISearchResultListener;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.carrot2.workbench.core.ui.SearchEditorSelectionProvider;
import org.carrot2.workbench.core.ui.SearchResultListenerAdapter;
import org.carrot2.workbench.vis.Activator;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBrowserVisualizationViewPage
extends Page {
    protected static final int BROWSER_MODEL_UPDATE_RETRY = 750;
    protected static final int BROWSER_MODEL_UPDATE_INITIAL = 250;
    protected static final int BROWSER_SELECTION_DELAY = 250;
    protected static final int BROWSER_CLIENTSIZE_DELAY = 250;
    public final SearchEditor editor;
    private Browser browser;
    private volatile boolean browserInitialized;
    private final String entryPageUri;
    private final AtomicInteger view = new AtomicInteger();
    private final Logger logger = LoggerFactory.getLogger((String)(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".view_" + this.view.incrementAndGet()));
    private final UpdateModelJob updateModelJob = new UpdateModelJob();
    private UpdateClientSizeJob updateClientSizeJob = new UpdateClientSizeJob();
    private PostponableJob selectionJob = new PostponableJob((Job)new UIJob("Browser (selection)..."){

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            return this.doSelectionRefresh();
        }

        protected IStatus doSelectionRefresh() {
            if (AbstractBrowserVisualizationViewPage.this.browser.isDisposed() || !AbstractBrowserVisualizationViewPage.this.browserInitialized) {
                return Status.OK_STATUS;
            }
            IStructuredSelection iStructuredSelection = (IStructuredSelection)AbstractBrowserVisualizationViewPage.this.editor.getSite().getSelectionProvider().getSelection();
            List list = iStructuredSelection.toList();
            IntStack intStack = new IntStack(list.size());
            for (Cluster cluster : list) {
                intStack.push(cluster.getId().intValue());
            }
            AbstractBrowserVisualizationViewPage.this.browser.execute("javascript:selectGroupsById(" + Arrays.toString(intStack.toArray()) + ");");
            return Status.OK_STATUS;
        }
    });
    private final SearchResultListenerAdapter editorSyncListener = new SearchResultListenerAdapter(){

        public void processingResultUpdated(ProcessingResult processingResult) {
            AbstractBrowserVisualizationViewPage.this.updateModelJob.updateModel(processingResult);
        }
    };
    private final ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            if (!AbstractBrowserVisualizationViewPage.this.browserInitialized) {
                return;
            }
            ISelection iSelection = selectionChangedEvent.getSelection();
            if (iSelection != null && iSelection instanceof IStructuredSelection) {
                Object[] objectArray;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                AbstractBrowserVisualizationViewPage.this.logger.debug("Selection, editor->visualization: " + iStructuredSelection);
                IAdapterManager iAdapterManager = Platform.getAdapterManager();
                ArrayList arrayList = Lists.newArrayList();
                Object[] objectArray2 = objectArray = iStructuredSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray2[n2];
                    Cluster cluster = (Cluster)iAdapterManager.getAdapter(object, Cluster.class);
                    if (cluster != null) {
                        arrayList.add(cluster);
                    }
                    ++n2;
                }
                AbstractBrowserVisualizationViewPage.this.selectionJob.reschedule(250);
            }
        }
    };

    public AbstractBrowserVisualizationViewPage(SearchEditor searchEditor, String string) {
        this.entryPageUri = string;
        this.editor = searchEditor;
    }

    public void createControl(Composite composite) {
        this.browser = BrowserFacade.createNew((Composite)composite, (int)0);
        Activator activator = Activator.getInstance();
        String string = activator.getFullURL(this.entryPageUri);
        new BrowserFunction(this.browser, "swt_onGroupSelectionChanged"){

            public Object function(Object[] objectArray) {
                if (!AbstractBrowserVisualizationViewPage.this.browserInitialized) {
                    return null;
                }
                Object[] objectArray2 = (Object[])objectArray[0];
                int[] nArray = new int[objectArray2.length];
                int n = 0;
                while (n < nArray.length) {
                    nArray[n] = (int)Double.parseDouble(objectArray2[n].toString());
                    ++n;
                }
                AbstractBrowserVisualizationViewPage.this.doGroupSelection(nArray);
                return null;
            }
        };
        new BrowserFunction(this.browser, "swt_onModelChanged"){

            public Object function(Object[] objectArray) {
                if (!AbstractBrowserVisualizationViewPage.this.browserInitialized) {
                    return null;
                }
                AbstractBrowserVisualizationViewPage.this.selectionJob.reschedule(250);
                return null;
            }
        };
        new BrowserFunction(this.browser, "swt_onVisualizationLoaded"){

            public Object function(Object[] objectArray) {
                AbstractBrowserVisualizationViewPage.this.browserInitialized = true;
                AbstractBrowserVisualizationViewPage.this.onBrowserReady();
                AbstractBrowserVisualizationViewPage.this.updateModelJob.updateModel(AbstractBrowserVisualizationViewPage.this.getProcessingResult());
                return null;
            }
        };
        new BrowserFunction(this.browser, "swt_log"){

            public Object function(Object[] objectArray) {
                AbstractBrowserVisualizationViewPage.this.logger.info("JS->SWT log: " + Arrays.toString(objectArray));
                return null;
            }
        };
        this.browserInitialized = false;
        this.browser.setUrl(string);
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent locationEvent) {
                if (!locationEvent.location.startsWith("file:")) {
                    locationEvent.doit = false;
                    AbstractBrowserVisualizationViewPage.openURL(locationEvent.location);
                }
            }
        });
        this.browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                AbstractBrowserVisualizationViewPage.this.logger.debug("Browser disposed.");
            }
        });
        this.browser.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                AbstractBrowserVisualizationViewPage.this.updateClientSize();
            }
        });
        this.editor.getSearchResult().addListener((ISearchResultListener)this.editorSyncListener);
        this.editor.getSite().getSelectionProvider().addSelectionChangedListener(this.selectionListener);
    }

    protected void onBrowserReady() {
        this.updateClientSize();
    }

    private void updateClientSize() {
        Rectangle rectangle = this.browser.getClientArea();
        this.logger.debug("Updating client size: " + rectangle);
        this.updateClientSizeJob.update(rectangle);
    }

    public Control getControl() {
        return this.browser;
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void dispose() {
        this.editor.getSearchResult().removeListener((ISearchResultListener)this.editorSyncListener);
        this.editor.getSite().getSelectionProvider().removeSelectionChangedListener(this.selectionListener);
        this.browser.dispose();
        super.dispose();
    }

    private void doGroupSelection(int[] nArray) {
        this.logger.debug("Selection visualization->editor: " + Arrays.toString(nArray));
        SearchEditorSelectionProvider searchEditorSelectionProvider = (SearchEditorSelectionProvider)this.editor.getSite().getSelectionProvider();
        searchEditorSelectionProvider.setSelected(nArray, new ISelectionChangedListener[]{this.selectionListener});
    }

    private ProcessingResult getProcessingResult() {
        assert (Display.getCurrent() != null);
        ProcessingResult processingResult = this.editor.getSearchResult().getProcessingResult();
        if (processingResult == null || processingResult.getClusters() == null) {
            return null;
        }
        return processingResult;
    }

    protected Browser getBrowser() {
        return this.browser;
    }

    public boolean isBrowserInitialized() {
        return this.browser != null && this.browserInitialized;
    }

    private static void openURL(String string) {
        try {
            WorkbenchCorePlugin.getDefault().getWorkbench().getBrowserSupport().createBrowser(46, null, null, null).openURL(new URL(string));
        }
        catch (Exception exception) {
            Utils.logError((String)"Couldn't open internal browser", (Throwable)exception, (boolean)false);
        }
    }

    private class UpdateClientSizeJob
    extends PostponableJob {
        private volatile Rectangle clientArea;

        public UpdateClientSizeJob() {
            this.setJob((Job)new UIJob("UpdateClientSize"){

                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    if (AbstractBrowserVisualizationViewPage.this.getBrowser().isDisposed()) {
                        AbstractBrowserVisualizationViewPage.this.logger.warn("Browser disposed.");
                        return Status.OK_STATUS;
                    }
                    Rectangle rectangle = UpdateClientSizeJob.this.clientArea;
                    if (rectangle == null) {
                        AbstractBrowserVisualizationViewPage.this.logger.warn("Area is null?");
                        return Status.OK_STATUS;
                    }
                    if (AbstractBrowserVisualizationViewPage.this.isBrowserInitialized()) {
                        AbstractBrowserVisualizationViewPage.this.logger.info("updateSize(): " + UpdateClientSizeJob.this.clientArea);
                        AbstractBrowserVisualizationViewPage.this.getBrowser().execute("javascript:updateSize(" + ((UpdateClientSizeJob)UpdateClientSizeJob.this).clientArea.width + ", " + ((UpdateClientSizeJob)UpdateClientSizeJob.this).clientArea.height + ")");
                    } else {
                        UpdateClientSizeJob.this.reschedule(250);
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        public void update(Rectangle rectangle) {
            this.clientArea = rectangle;
            this.reschedule(250);
        }
    }

    private class UpdateModelJob
    extends PostponableJob {
        private AtomicReference<ProcessingResult> currentModel = new AtomicReference();
        private ProcessingResult updatedModel;

        public UpdateModelJob() {
            this.setJob((Job)new UIJob("Visualization model update"){

                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    if (AbstractBrowserVisualizationViewPage.this.getBrowser().isDisposed()) {
                        AbstractBrowserVisualizationViewPage.this.logger.warn("Browser disposed.");
                        return Status.OK_STATUS;
                    }
                    if (!AbstractBrowserVisualizationViewPage.this.browserInitialized) {
                        if (AbstractBrowserVisualizationViewPage.this.browser.isVisible()) {
                            AbstractBrowserVisualizationViewPage.this.logger.debug("Model update delayed (browser not ready).");
                            UpdateModelJob.this.reschedule(750);
                        } else {
                            AbstractBrowserVisualizationViewPage.this.logger.debug("Model update delayed (browser invisible).");
                        }
                        return Status.OK_STATUS;
                    }
                    if (UpdateModelJob.this.updatedModel == UpdateModelJob.this.currentModel.getAndSet(UpdateModelJob.this.updatedModel) || UpdateModelJob.this.updatedModel == null) {
                        return Status.OK_STATUS;
                    }
                    this.doUpdateModel((ProcessingResult)UpdateModelJob.this.currentModel.get());
                    return Status.OK_STATUS;
                }

                private void doUpdateModel(ProcessingResult processingResult) {
                    try {
                        StringWriter stringWriter = new StringWriter();
                        processingResult.serializeJson((Writer)stringWriter, "updateDataJson", true, false, true, false);
                        String string = stringWriter.toString();
                        String string2 = StringUtils.abbreviate((String)string, (int)180);
                        AbstractBrowserVisualizationViewPage.this.logger.info("Updating view XML: " + string2);
                        if (!AbstractBrowserVisualizationViewPage.this.browser.execute("javascript:" + string)) {
                            AbstractBrowserVisualizationViewPage.this.logger.warn("Failed to update the data model: " + string2);
                        }
                    }
                    catch (Exception exception) {
                        AbstractBrowserVisualizationViewPage.this.logger.warn("Browser model update error.", (Throwable)exception);
                    }
                }
            });
        }

        public void updateModel(ProcessingResult processingResult) {
            if (AbstractBrowserVisualizationViewPage.this.browser.isDisposed()) {
                return;
            }
            this.updatedModel = processingResult;
            this.reschedule(250);
        }
    }
}

