/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.vis;

import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    public static final String ID = "org.carrot2.workbench.vis.carrotsearch";
    private static Activator instance;
    private WeakHashMap<SearchEditor, Integer> editors = new WeakHashMap();
    private int sequencer;
    private String staticResourceURL;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        URL uRL = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path("web"), null);
        URL uRL2 = FileLocator.toFileURL((URL)uRL);
        LoggerFactory.getLogger(Activator.class).debug("Bundled resources at: " + uRL2.toExternalForm());
        if (!"file".equals(uRL2.getProtocol())) {
            throw new Exception("Expected file protocol on bundled Web resources: " + uRL2.toExternalForm());
        }
        this.staticResourceURL = uRL2.toExternalForm();
        while (this.staticResourceURL.endsWith("/")) {
            this.staticResourceURL = this.staticResourceURL.substring(0, this.staticResourceURL.length() - 1);
        }
        instance = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        instance = null;
        super.stop(bundleContext);
    }

    public String getFullURL(String string) {
        String string2 = this.staticResourceURL;
        if (!string.startsWith("/")) {
            return String.valueOf(string2) + "/" + string;
        }
        return String.valueOf(string2) + string;
    }

    final void logInfo(String string) {
        this.getLog().log((IStatus)new Status(1, ID, string));
    }

    public static Activator getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchEditor getEditor(int n) {
        Activator activator = this;
        synchronized (activator) {
            for (Map.Entry<SearchEditor, Integer> entry : this.editors.entrySet()) {
                if (entry.getValue() != n) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerEditor(SearchEditor searchEditor) {
        Activator activator = this;
        synchronized (activator) {
            Integer n = this.editors.get(searchEditor);
            if (n != null) {
                return n;
            }
            this.editors.put(searchEditor, ++this.sequencer);
            return this.sequencer;
        }
    }
}

