/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.vis.foamtree;

import org.carrot2.workbench.core.ui.SearchEditor;
import org.carrot2.workbench.core.ui.actions.ExportImageAction;
import org.carrot2.workbench.core.ui.actions.IControlProvider;
import org.carrot2.workbench.vis.AbstractBrowserVisualizationViewPage;
import org.carrot2.workbench.vis.Activator;
import org.carrot2.workbench.vis.foamtree.LayoutInitializerAction;
import org.carrot2.workbench.vis.foamtree.ToggleRelaxationAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.IPageSite;

final class FoamTreeViewPage
extends AbstractBrowserVisualizationViewPage {
    private static final String ENTRY_PAGE = "/foamtree.html";
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            if (string.equals("relaxation-enabled") || string.equals("layout-initializer")) {
                if (Display.getCurrent() == null) {
                    throw new IllegalStateException();
                }
                if (FoamTreeViewPage.this.isBrowserInitialized()) {
                    FoamTreeViewPage.this.passAttributes();
                    FoamTreeViewPage.this.getBrowser().execute("javascript:vis.set('dataObject', vis.get('dataObject'))");
                }
            }
        }
    };

    public FoamTreeViewPage(SearchEditor searchEditor) {
        super(searchEditor, ENTRY_PAGE);
    }

    @Override
    protected void onBrowserReady() {
        super.onBrowserReady();
        this.passAttributes();
    }

    protected void passAttributes() {
        if (this.isBrowserInitialized()) {
            Browser browser = this.getBrowser();
            browser.execute("javascript:vis.set({relaxationVisible: " + ToggleRelaxationAction.getCurrent() + "," + "initializer: '" + LayoutInitializerAction.getCurrent().id + "'})");
        }
    }

    public void init(IPageSite iPageSite) {
        super.init(iPageSite);
        IPreferenceStore iPreferenceStore = Activator.getInstance().getPreferenceStore();
        iPreferenceStore.addPropertyChangeListener(this.listener);
        iPageSite.getActionBars().getToolBarManager().add((IAction)new ExportImageAction(new IControlProvider(){

            public Control getControl() {
                return FoamTreeViewPage.this.getControl();
            }
        }));
    }

    @Override
    public void dispose() {
        super.dispose();
        IPreferenceStore iPreferenceStore = Activator.getInstance().getPreferenceStore();
        iPreferenceStore.removePropertyChangeListener(this.listener);
    }
}

