/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.vis.foamtree;

import org.carrot2.workbench.core.helpers.DropDownMenuAction;
import org.carrot2.workbench.core.ui.actions.IPropertyHost;
import org.carrot2.workbench.core.ui.actions.PreferenceStorePropertyHost;
import org.carrot2.workbench.vis.Activator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class LayoutInitializerAction
extends Action {
    public static final String LAYOUT_INITIALIZER_KEY = "layout-initializer";
    private final IMenuCreator menuCreator;

    private LayoutInitializerAction(String string, IPropertyHost iPropertyHost) {
        super("FoamTree layout initializer", 4);
        Enum[] enumArray = LayoutAlgorithm.values();
        this.menuCreator = DropDownMenuAction.getMenuFor((String)string, (String)this.getText(), (Enum[])enumArray, (IPropertyHost)iPropertyHost);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.carrot2.workbench.vis.carrotsearch", (String)"icons/enabled/layout.gif"));
        this.setMenuCreator(this.menuCreator);
    }

    public LayoutInitializerAction() {
        this(LAYOUT_INITIALIZER_KEY, (IPropertyHost)new PreferenceStorePropertyHost(Activator.getInstance().getPreferenceStore()));
    }

    public void runWithEvent(Event event) {
        DropDownMenuAction.showMenu((IAction)this, (Event)event);
    }

    static LayoutAlgorithm getCurrent() {
        IPreferenceStore iPreferenceStore = Activator.getInstance().getPreferenceStore();
        try {
            return LayoutAlgorithm.valueOf(iPreferenceStore.getString(LAYOUT_INITIALIZER_KEY));
        }
        catch (Exception exception) {
            return LayoutAlgorithm.FISHEYE;
        }
    }

    public static enum LayoutAlgorithm {
        FISHEYE("Large groups in the center", "fisheye"),
        BLACKHOLE("Small groups in the center", "blackhole"),
        TREEMAP("TreeMap-like", "treemap"),
        RANDOM("Random group positions", "random");

        final String label;
        final String id;

        private LayoutAlgorithm(String string2, String string3) {
            this.label = string2;
            this.id = string3;
        }

        public String toString() {
            return this.label;
        }
    }
}

