/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.vis.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeInstance;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.velocity.VelocityInitializer;
import org.carrot2.workbench.vis.http.HttpServletUtils;

public final class VelocityServlet
extends HttpServlet {
    private static final String DEFAULT_CONTENT_TYPE = "text/plain; charset=UTF-8";
    private RuntimeInstance velocity;
    private String templatesPrefix;
    private String contentType = "text/plain; charset=UTF-8";

    public void init() throws ServletException {
        super.init();
        if (this.getInitParameter("content-type") != null) {
            this.contentType = this.getInitParameter("content-type");
        }
        this.templatesPrefix = this.getInitParameter("templates-prefix") != null ? this.getInitParameter("templates-prefix") : "";
        if (StringUtils.isEmpty((String)this.getInitParameter("bundleID"))) {
            throw new ServletException("Init attribute required: bundleID");
        }
        this.velocity = VelocityInitializer.createInstance((String)this.getInitParameter("bundleID"), (String)this.templatesPrefix);
    }

    public void destroy() {
        super.destroy();
        this.velocity = null;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getRequestURI();
        try {
            Template template = this.velocity.getTemplate(string);
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("request", (Object)httpServletRequest);
            HttpServletUtils.sendNoCache(httpServletResponse);
            httpServletResponse.setContentType(this.contentType);
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            ((Writer)printWriter).close();
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            httpServletResponse.sendError(404);
        }
        catch (Exception exception) {
            Utils.logError((String)("Template parsing failed: " + string), (Throwable)exception, (boolean)false);
        }
    }
}

