/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.stc;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntStack;
import java.util.ArrayList;
import org.carrot2.text.suffixtree.IntegerSequence;
import org.carrot2.text.suffixtree.SuffixTree;
import org.carrot2.text.suffixtree.SuffixTreeBuilder;

final class GeneralizedSuffixTree {
    private GeneralizedSuffixTree() {
    }

    static class SequenceBuilder {
        private int separator = -1;
        public final IntStack input = new IntStack();
        public IntStack documentMarkers = new IntStack();
        public IntStack stateOriginDocument = new IntStack();
        public SuffixTree stree;

        SequenceBuilder() {
        }

        public void addPhrase(int[] nArray, int n, int n2) {
            this.input.push(nArray, n, n2);
            this.input.push(this.separator--);
        }

        public void addPhrase(int ... nArray) {
            this.addPhrase(nArray, 0, nArray.length);
        }

        public void endDocument() {
            this.documentMarkers.push(this.input.size());
        }

        public void buildSuffixTree() {
            this.stateOriginDocument.clear();
            LeafStateMarker leafStateMarker = new LeafStateMarker();
            IntegerSequence integerSequence = new IntegerSequence(this.input.buffer, 0, this.input.elementsCount);
            this.stree = SuffixTreeBuilder.from(integerSequence).withProgressCallback(leafStateMarker).withStateCallback(leafStateMarker).build();
        }

        private final class LeafStateMarker
        implements SuffixTree.IStateCallback,
        SuffixTree.IProgressCallback {
            private int currentDocument = 0;
            private int markerIndex = 0;

            private LeafStateMarker() {
            }

            @Override
            public void next(int n) {
                if (n == SequenceBuilder.this.documentMarkers.get(this.markerIndex)) {
                    ++this.currentDocument;
                    ++this.markerIndex;
                }
            }

            @Override
            public void newState(int n, int n2) {
                while (SequenceBuilder.this.stateOriginDocument.size() < n) {
                    SequenceBuilder.this.stateOriginDocument.push(-1);
                }
                SequenceBuilder.this.stateOriginDocument.push(this.currentDocument);
            }
        }
    }

    static abstract class Visitor {
        private final IntStack edges = new IntStack();
        private final ArrayList<BitSet> bsets = new ArrayList();
        private final SuffixTree stree;
        protected final SequenceBuilder sb;
        private int minCardinality;

        public Visitor(SequenceBuilder sequenceBuilder, int n) {
            assert (n > 1);
            this.stree = sequenceBuilder.stree;
            this.sb = sequenceBuilder;
            this.minCardinality = n;
        }

        public void visit() {
            if (this.stree.isLeaf(this.stree.getRootState())) {
                return;
            }
            this.countDocs(0, this.stree.getRootState());
        }

        private void countDocs(int n, int n2) {
            assert (!this.stree.isLeaf(n2));
            BitSet bitSet = this.getBitSet(n);
            int n3 = this.stree.firstEdge(n2);
            while (n3 != -1) {
                int n4 = this.stree.getToState(n3);
                if (this.stree.isLeaf(n4)) {
                    int n5 = this.sb.stateOriginDocument.get(n4);
                    bitSet.set((long)n5);
                } else {
                    BitSet bitSet2 = this.getBitSet(n + 1);
                    bitSet2.clear();
                    this.edges.push(this.stree.getStartIndex(n3), this.stree.getEndIndex(n3));
                    this.countDocs(n + 1, n4);
                    this.edges.discard(2);
                    bitSet.or(bitSet2);
                }
                n3 = this.stree.nextEdge(n3);
            }
            if (this.stree.getRootState() != n2 && (n3 = (int)bitSet.cardinality()) >= this.minCardinality) {
                this.visit(n2, n3, bitSet, this.edges);
            }
        }

        protected abstract void visit(int var1, int var2, BitSet var3, IntStack var4);

        private BitSet getBitSet(int n) {
            while (this.bsets.size() <= n) {
                this.bsets.add(new BitSet());
            }
            return this.bsets.get(n);
        }
    }
}

