/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.stc;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.BitSetIterator;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntStack;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.carrot2.clustering.stc.ClusterCandidate;
import org.carrot2.clustering.stc.GeneralizedSuffixTree;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.IClusteringAlgorithm;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.ProcessingComponentBase;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.CommonAttributes;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.text.analysis.TokenTypeUtils;
import org.carrot2.text.clustering.IMonolingualClusteringAlgorithm;
import org.carrot2.text.clustering.MultilingualClustering;
import org.carrot2.text.linguistic.ILexicalData;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.pipeline.BasicPreprocessingPipeline;
import org.carrot2.text.preprocessing.pipeline.IPreprocessingPipeline;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.DoubleRange;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.carrot2.util.attribute.constraint.IntRange;

@Bindable(prefix="STCClusteringAlgorithm", inherit={CommonAttributes.class})
@Label(value="STC Clustering")
public final class STCClusteringAlgorithm
extends ProcessingComponentBase
implements IClusteringAlgorithm {
    private static final String BASE_CLUSTERS = "Base clusters";
    private static final String MERGING_AND_OUTPUT = "Merging and output";
    @Processing
    @Input
    @Internal
    @Attribute(key="query", inherit=true)
    public String query = null;
    @Processing
    @Input
    @Required
    @Internal
    @Attribute(key="documents", inherit=true)
    public List<Document> documents;
    @Processing
    @Output
    @Internal
    @Attribute(key="clusters", inherit=true)
    public List<Cluster> clusters = null;
    @Processing
    @Input
    @Attribute
    @IntRange(min=2)
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Word filtering")
    public int ignoreWordIfInFewerDocs = 2;
    @Processing
    @Input
    @Attribute
    @DoubleRange(min=0.0, max=1.0)
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Word filtering")
    public double ignoreWordIfInHigherDocsPercent = 0.9;
    @Processing
    @Input
    @Attribute
    @DoubleRange(min=0.0, max=10.0)
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Base clusters")
    public double minBaseClusterScore = 2.0;
    @Processing
    @Input
    @Attribute
    @IntRange(min=2)
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Base clusters")
    public int maxBaseClusters = 300;
    @Processing
    @Input
    @Attribute
    @IntRange(min=2, max=20)
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Base clusters")
    public int minBaseClusterSize = 2;
    @Processing
    @Input
    @Attribute
    @IntRange(min=1)
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Merging and output")
    public int maxClusters = 15;
    @Processing
    @Input
    @Attribute
    @DoubleRange(min=0.0, max=1.0)
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Merging and output")
    public double mergeThreshold = 0.6;
    @Processing
    @Input
    @Attribute
    @DoubleRange(min=0.0, max=1.0)
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Labels")
    public double maxPhraseOverlap = 0.6;
    @Processing
    @Input
    @Attribute
    @DoubleRange(min=0.0, max=1.0)
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Labels")
    public double mostGeneralPhraseCoverage = 0.5;
    @Processing
    @Input
    @Attribute
    @IntRange(min=1)
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Labels")
    public int maxDescPhraseLength = 4;
    @Processing
    @Input
    @Attribute
    @IntRange(min=1)
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Labels")
    public int maxPhrases = 3;
    @Processing
    @Input
    @Attribute
    @DoubleRange(min=0.0)
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Base clusters")
    public double singleTermBoost = 0.5;
    @Processing
    @Input
    @Attribute
    @IntRange(min=1)
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Base clusters")
    public int optimalPhraseLength = 3;
    @Processing
    @Input
    @Attribute
    @DoubleRange(min=0.5)
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Base clusters")
    public double optimalPhraseLengthDev = 2.0;
    @Processing
    @Input
    @Attribute
    @DoubleRange(min=0.0)
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Base clusters")
    public double documentCountBoost = 1.0;
    @Init
    @Input
    @Attribute
    @Internal
    @ImplementingClasses(classes={BasicPreprocessingPipeline.class}, strict=false)
    @Level(value=AttributeLevel.ADVANCED)
    public IPreprocessingPipeline preprocessingPipeline = new BasicPreprocessingPipeline();
    @Input
    @Processing
    @Attribute
    @DoubleRange(min=0.0, max=1.0)
    @Label(value="Size-Score sorting ratio")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Clusters")
    public double scoreWeight = 1.0;
    @Input
    @Processing
    @Attribute
    @Label(value="Merge all stem-equivalent phrases when discovering base clusters")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Clusters")
    public boolean mergeStemEquivalentBaseClusters = true;
    public final MultilingualClustering multilingualClustering = new MultilingualClustering();
    PreprocessingContext context;
    GeneralizedSuffixTree.SequenceBuilder sb;
    private static final Predicate<PhraseCandidate> notSelected = new Predicate<PhraseCandidate>(){

        public boolean apply(PhraseCandidate phraseCandidate) {
            return !phraseCandidate.selected;
        }
    };

    public void process() throws ProcessingException {
        List<Document> list = this.documents;
        this.clusters = this.multilingualClustering.process(this.documents, new IMonolingualClusteringAlgorithm(){

            public List<Cluster> process(List<Document> list, LanguageCode languageCode) {
                STCClusteringAlgorithm.this.documents = list;
                STCClusteringAlgorithm.this.cluster(languageCode);
                return STCClusteringAlgorithm.this.clusters;
            }
        });
        this.documents = list;
    }

    private void cluster(LanguageCode languageCode) {
        this.clusters = new ArrayList<Cluster>();
        this.context = this.preprocessingPipeline.preprocess(this.documents, this.query, languageCode);
        this.sb = new GeneralizedSuffixTree.SequenceBuilder();
        int[] nArray = this.context.allTokens.wordIndex;
        short[] sArray = this.context.allTokens.type;
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] == -1) {
                if ((sArray[n] & 0xA00) != 0) {
                    this.sb.endDocument();
                }
            } else {
                int n2 = n;
                while (nArray[n + 1] != -1) {
                    ++n;
                }
                int n3 = 1 + n - n2;
                if (n3 >= 1) {
                    this.sb.addPhrase(nArray, n2, n3);
                }
            }
            ++n;
        }
        this.sb.buildSuffixTree();
        List<ClusterCandidate> list = this.createBaseClusters(this.sb);
        ArrayList<ClusterCandidate> arrayList = this.createMergedClusters(list);
        this.postProcessing(arrayList);
    }

    public void afterProcessing() {
        super.afterProcessing();
        this.context = null;
        this.sb = null;
    }

    private List<ClusterCandidate> createBaseClusters(GeneralizedSuffixTree.SequenceBuilder sequenceBuilder) {
        final ArrayList arrayList = Lists.newArrayList();
        new GeneralizedSuffixTree.Visitor(sequenceBuilder, this.minBaseClusterSize){

            @Override
            protected void visit(int n, int n2, BitSet bitSet, IntStack intStack) {
                if (!$assertionsDisabled && n2 < STCClusteringAlgorithm.this.minBaseClusterSize) {
                    throw new AssertionError();
                }
                if (!STCClusteringAlgorithm.this.checkAcceptablePhrase(intStack)) {
                    return;
                }
                int n3 = STCClusteringAlgorithm.this.effectivePhraseLength(intStack);
                if (n3 == 0) {
                    return;
                }
                float f = STCClusteringAlgorithm.this.baseClusterScore(n3, n2);
                arrayList.add(new ClusterCandidate(intStack.toArray(), (BitSet)bitSet.clone(), n2, f));
            }
        }.visit();
        if (this.mergeStemEquivalentBaseClusters) {
            this.mergeStemEquivalentBaseClusters(sequenceBuilder, arrayList);
        }
        int n = 0;
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            ClusterCandidate clusterCandidate = (ClusterCandidate)arrayList.get(n3);
            if ((double)clusterCandidate.score >= this.minBaseClusterScore) {
                arrayList.set(n++, clusterCandidate);
            }
            ++n3;
        }
        arrayList.subList(n, arrayList.size()).clear();
        Collections.sort(arrayList, new Comparator<ClusterCandidate>(){

            @Override
            public int compare(ClusterCandidate clusterCandidate, ClusterCandidate clusterCandidate2) {
                return -Float.compare(clusterCandidate.score, clusterCandidate2.score);
            }
        });
        n = 0;
        ILexicalData iLexicalData = this.context.language.getLexicalData();
        n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3 && n < this.maxBaseClusters) {
            ClusterCandidate clusterCandidate = (ClusterCandidate)arrayList.get(n4);
            assert (clusterCandidate.phrases.size() == 1);
            if (!iLexicalData.isStopLabel((CharSequence)this.buildLabel(clusterCandidate.phrases.get(0)))) {
                arrayList.set(n++, clusterCandidate);
            }
            ++n4;
        }
        if (n < arrayList.size()) {
            arrayList.subList(n, arrayList.size()).clear();
            assert (arrayList.size() == n);
        }
        return arrayList;
    }

    private void mergeStemEquivalentBaseClusters(GeneralizedSuffixTree.SequenceBuilder sequenceBuilder, List<ClusterCandidate> list) {
        HashMap hashMap = Maps.newHashMap();
        int n = 0;
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            ClusterCandidate clusterCandidate = list.get(n3);
            list.set(n, clusterCandidate);
            assert (clusterCandidate.phrases.size() == 1);
            int[] nArray = this.context.allWords.stemIndex;
            int[] nArray2 = clusterCandidate.phrases.get(0);
            IntArrayList intArrayList = new IntArrayList(nArray2.length);
            int[] nArray3 = nArray2;
            int n4 = nArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                int n6 = nArray3[n5];
                int n7 = sequenceBuilder.input.get(n6);
                intArrayList.add(nArray[n7]);
                ++n5;
            }
            ClusterCandidate clusterCandidate2 = (ClusterCandidate)hashMap.get(intArrayList);
            if (clusterCandidate2 == null) {
                hashMap.put(intArrayList, clusterCandidate);
                ++n;
            } else {
                if (clusterCandidate2.cardinality < clusterCandidate.cardinality) {
                    clusterCandidate2.cardinality = clusterCandidate.cardinality;
                    clusterCandidate2.phrases.add(0, clusterCandidate.phrases.get(0));
                } else {
                    clusterCandidate2.phrases.add(clusterCandidate.phrases.get(0));
                }
                clusterCandidate2.documents.or(clusterCandidate.documents);
            }
            ++n3;
        }
        list.subList(n, list.size()).clear();
        IntStack intStack = new IntStack();
        for (ClusterCandidate clusterCandidate : list) {
            if (clusterCandidate.phrases.size() <= 1) continue;
            clusterCandidate.cardinality = (int)clusterCandidate.documents.cardinality();
            intStack.buffer = clusterCandidate.phrases.get(0);
            intStack.elementsCount = intStack.buffer.length;
            clusterCandidate.score = this.baseClusterScore(this.effectivePhraseLength(intStack), clusterCandidate.cardinality);
            clusterCandidate.phrases.subList(1, clusterCandidate.phrases.size()).clear();
        }
    }

    private ArrayList<ClusterCandidate> createMergedClusters(List<ClusterCandidate> list) {
        ClusterCandidate clusterCandidate;
        ClusterCandidate clusterCandidate2;
        IntStack intStack = new IntStack();
        intStack.push(-1);
        int[] nArray = new int[list.size()];
        float f = (float)this.mergeThreshold;
        int n = 0;
        while (n < list.size()) {
            int n2 = n + 1;
            while (n2 < list.size()) {
                clusterCandidate2 = list.get(n);
                clusterCandidate = list.get(n2);
                float f2 = clusterCandidate2.cardinality;
                float f3 = clusterCandidate.cardinality;
                float f4 = BitSet.intersectionCount((BitSet)clusterCandidate2.documents, (BitSet)clusterCandidate.documents);
                if (f4 / f2 > f && f4 / f3 > f) {
                    intStack.push(nArray[n], n2);
                    nArray[n] = intStack.size() - 2;
                    intStack.push(nArray[n2], n);
                    nArray[n2] = intStack.size() - 2;
                }
                ++n2;
            }
            ++n;
        }
        int[] nArray2 = new int[list.size()];
        Arrays.fill(nArray2, -1);
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        clusterCandidate2 = new IntStack(list.size());
        clusterCandidate = new IntStack(list.size());
        int n3 = 0;
        int n4 = 0;
        while (n4 < list.size()) {
            if (nArray2[n4] == -1) {
                clusterCandidate2.push(n4);
                while (clusterCandidate2.size() > 0) {
                    int n5 = clusterCandidate2.pop();
                    assert (nArray2[n5] == -1 || nArray2[n5] == n3);
                    if (nArray2[n5] == n3) continue;
                    nArray2[n5] = n3;
                    clusterCandidate.push(n5);
                    int n6 = nArray[n5];
                    while (intStack.get(n6) != -1) {
                        int n7 = intStack.get(n6 + 1);
                        if (nArray2[n7] == -1) {
                            clusterCandidate2.push(n7);
                        } else assert (nArray2[n7] == n3);
                        n6 = intStack.get(n6);
                    }
                }
                ++n3;
                arrayList.add(this.merge((IntStack)clusterCandidate, list));
                clusterCandidate.clear();
            }
            ++n4;
        }
        Collections.sort(arrayList, new Comparator<ClusterCandidate>(){

            @Override
            public int compare(ClusterCandidate clusterCandidate, ClusterCandidate clusterCandidate2) {
                if (clusterCandidate.score < clusterCandidate2.score) {
                    return 1;
                }
                if (clusterCandidate.score > clusterCandidate2.score) {
                    return -1;
                }
                if (clusterCandidate.cardinality < clusterCandidate2.cardinality) {
                    return 1;
                }
                if (clusterCandidate.cardinality > clusterCandidate2.cardinality) {
                    return -1;
                }
                return 0;
            }
        });
        if (arrayList.size() > this.maxClusters) {
            arrayList.subList(this.maxClusters, arrayList.size()).clear();
        }
        return arrayList;
    }

    private ClusterCandidate merge(IntStack intStack, List<ClusterCandidate> list) {
        assert (intStack.size() > 0);
        ClusterCandidate clusterCandidate = new ClusterCandidate();
        int n = 0;
        while (n < intStack.size()) {
            ClusterCandidate clusterCandidate2 = list.get(intStack.get(n));
            clusterCandidate.documents.or(clusterCandidate2.documents);
            clusterCandidate.score += clusterCandidate2.score;
            ++n;
        }
        clusterCandidate.cardinality = (int)clusterCandidate.documents.cardinality();
        ArrayList<PhraseCandidate> arrayList = new ArrayList<PhraseCandidate>(intStack.size());
        int n2 = 0;
        while (n2 < intStack.size()) {
            ClusterCandidate object = list.get(intStack.get(n2));
            float f = (float)object.cardinality / (float)clusterCandidate.cardinality;
            arrayList.add(new PhraseCandidate(object, f));
            ++n2;
        }
        this.markSubSuperPhrases(arrayList);
        Collections2.filter(arrayList, notSelected).clear();
        this.markOverlappingPhrases(arrayList);
        Collections2.filter(arrayList, notSelected).clear();
        Collections.sort(arrayList, new Comparator<PhraseCandidate>(){

            @Override
            public int compare(PhraseCandidate phraseCandidate, PhraseCandidate phraseCandidate2) {
                if (phraseCandidate.coverage < phraseCandidate2.coverage) {
                    return 1;
                }
                if (phraseCandidate.coverage > phraseCandidate2.coverage) {
                    return -1;
                }
                return 0;
            }
        });
        n2 = this.maxPhrases;
        for (PhraseCandidate phraseCandidate : arrayList) {
            if (n2-- <= 0) break;
            clusterCandidate.phrases.add(phraseCandidate.cluster.phrases.get(0));
        }
        return clusterCandidate;
    }

    private void markSubSuperPhrases(ArrayList<PhraseCandidate> arrayList) {
        int n;
        int n2 = arrayList.size();
        IntStack intStack = new IntStack(this.maxDescPhraseLength * arrayList.size());
        IntStack intStack2 = new IntStack(arrayList.size() * 2);
        for (PhraseCandidate phraseCandidate : arrayList) {
            this.appendWords(intStack, intStack2, phraseCandidate);
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n2) {
                if (n3 != n4 && (n = STCClusteringAlgorithm.indexOf(intStack.buffer, intStack2.get(2 * n3), intStack2.get(2 * n3 + 1), intStack.buffer, intStack2.get(2 * n4), intStack2.get(2 * n4 + 1))) >= 0) {
                    arrayList.get((int)n3).mostGeneral = false;
                    arrayList.get((int)n4).mostSpecific = false;
                }
                ++n4;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            PhraseCandidate phraseCandidate = arrayList.get(n3);
            if (phraseCandidate.mostGeneral) {
                n = 0;
                while (n < n2) {
                    int n5;
                    PhraseCandidate phraseCandidate2 = arrayList.get(n);
                    if (n3 != n && phraseCandidate2.mostSpecific && (n5 = STCClusteringAlgorithm.indexOf(intStack.buffer, intStack2.get(2 * n), intStack2.get(2 * n + 1), intStack.buffer, intStack2.get(2 * n3), intStack2.get(2 * n3 + 1))) >= 0 && (double)(phraseCandidate.coverage - phraseCandidate2.coverage) < this.mostGeneralPhraseCoverage) {
                        phraseCandidate.selected = false;
                        n = n2;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        for (PhraseCandidate phraseCandidate : arrayList) {
            if (phraseCandidate.mostGeneral || phraseCandidate.mostSpecific) continue;
            phraseCandidate.selected = false;
        }
    }

    private void markOverlappingPhrases(ArrayList<PhraseCandidate> arrayList) {
        int n = arrayList.size();
        IntStack intStack = new IntStack(this.maxDescPhraseLength * arrayList.size());
        IntStack intStack2 = new IntStack(arrayList.size() * 2);
        for (PhraseCandidate phraseCandidate : arrayList) {
            this.appendUniqueWords(intStack, intStack2, phraseCandidate);
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            while (n3 < n) {
                PhraseCandidate phraseCandidate = arrayList.get(n2);
                PhraseCandidate phraseCandidate2 = arrayList.get(n3);
                int n4 = intStack2.get(2 * n2 + 1);
                int n5 = intStack2.get(2 * n3 + 1);
                float f = STCClusteringAlgorithm.computeIntersection(intStack.buffer, intStack2.get(2 * n2), n4, intStack.buffer, intStack2.get(2 * n3), n5);
                if ((double)(f / (float)n5) > this.maxPhraseOverlap && phraseCandidate2.coverage < phraseCandidate.coverage) {
                    phraseCandidate2.selected = false;
                }
                if ((double)(f / (float)n4) > this.maxPhraseOverlap && phraseCandidate.coverage < phraseCandidate2.coverage) {
                    phraseCandidate.selected = false;
                }
                ++n3;
            }
            ++n2;
        }
    }

    static int computeIntersection(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4) {
        int n5 = n + n2;
        int n6 = n3 + n4;
        int n7 = 0;
        while (n < n5 && n3 < n6) {
            int n8 = nArray[n];
            int n9 = nArray2[n3];
            if (n8 >= n9) {
                ++n3;
            }
            if (n8 <= n9) {
                ++n;
            }
            if (n8 != n9) continue;
            ++n7;
        }
        return n7;
    }

    private void appendUniqueWords(IntStack intStack, IntStack intStack2, PhraseCandidate phraseCandidate) {
        int n;
        assert (phraseCandidate.cluster.phrases.size() == 1);
        int n2 = intStack.size();
        int[] nArray = phraseCandidate.cluster.phrases.get(0);
        short[] sArray = this.context.allWords.type;
        int n3 = 0;
        while (n3 < nArray.length) {
            n = nArray[n3];
            while (n <= nArray[n3 + 1]) {
                int n4 = this.sb.input.get(n);
                if (!TokenTypeUtils.isCommon((int)sArray[n4])) {
                    intStack.push(n4);
                }
                ++n;
            }
            n3 += 2;
        }
        Arrays.sort(intStack.buffer, n2, intStack.size());
        n3 = n2;
        n = n2 + 1;
        while (n < intStack.size()) {
            if (intStack.buffer[n3] != intStack.buffer[n]) {
                intStack.buffer[++n3] = intStack.buffer[n];
            }
            ++n;
        }
        intStack.elementsCount = n3 + 1;
        intStack2.push(n2, intStack.size() - n2);
    }

    private void appendWords(IntStack intStack, IntStack intStack2, PhraseCandidate phraseCandidate) {
        int n = intStack.size();
        int[] nArray = phraseCandidate.cluster.phrases.get(0);
        short[] sArray = this.context.allWords.type;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            while (n3 <= nArray[n2 + 1]) {
                int n4 = this.sb.input.get(n3);
                if (!TokenTypeUtils.isCommon((int)sArray[n4])) {
                    intStack.push(n4);
                }
                ++n3;
            }
            n2 += 2;
        }
        intStack2.push(n, intStack.size() - n);
    }

    private void postProcessing(List<ClusterCandidate> list) {
        BitSet bitSet = new BitSet((long)this.documents.size());
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)this.documents.size());
        ArrayList arrayList2 = Lists.newArrayListWithCapacity((int)3);
        for (ClusterCandidate clusterCandidate : list) {
            Cluster cluster = new Cluster();
            cluster.addPhrases(this.collectPhrases(arrayList2, clusterCandidate));
            cluster.addDocuments(this.collectDocuments(arrayList, clusterCandidate.documents));
            cluster.setScore(Double.valueOf(clusterCandidate.score));
            this.clusters.add(cluster);
            bitSet.or(clusterCandidate.documents);
            arrayList.clear();
            arrayList2.clear();
        }
        Collections.sort(this.clusters, Cluster.byReversedWeightedScoreAndSizeComparator((double)this.scoreWeight));
        Cluster.appendOtherTopics(this.documents, this.clusters);
    }

    private List<String> collectPhrases(List<String> list, ClusterCandidate clusterCandidate) {
        assert (list != null);
        for (int[] nArray : clusterCandidate.phrases) {
            list.add(this.buildLabel(nArray));
        }
        return list;
    }

    private List<Document> collectDocuments(List<Document> arrayList, BitSet bitSet) {
        if (arrayList == null) {
            arrayList = Lists.newArrayListWithCapacity((int)((int)bitSet.cardinality()));
        }
        BitSetIterator bitSetIterator = bitSet.iterator();
        int n = bitSetIterator.nextSetBit();
        while (n >= 0) {
            arrayList.add(this.documents.get(n));
            n = bitSetIterator.nextSetBit();
        }
        return arrayList;
    }

    private String buildLabel(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n += nArray[n2 + 1] - nArray[n2] + 1;
            n2 += 2;
        }
        boolean[] blArray = new boolean[n];
        char[][] cArrayArray = new char[n][];
        short[] sArray = this.context.allWords.type;
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = nArray[n4];
            while (n5 <= nArray[n4 + 1]) {
                int n6 = this.sb.input.get(n5);
                cArrayArray[n3] = this.context.allWords.image[n6];
                blArray[n3] = TokenTypeUtils.isCommon((int)sArray[n6]);
                ++n5;
                ++n3;
            }
            n4 += 2;
        }
        return LabelFormatter.format((char[][])cArrayArray, (boolean[])blArray, (boolean)this.context.language.getLanguageCode().usesSpaceDelimiters());
    }

    private String toString(PhraseCandidate phraseCandidate) {
        return String.format(Locale.ENGLISH, "%3.2f %s %s %s %s", Float.valueOf(phraseCandidate.coverage), this.buildLabel(phraseCandidate.cluster.phrases.get(0)), phraseCandidate.selected ? "S" : "", phraseCandidate.mostGeneral ? "MG" : "", phraseCandidate.mostSpecific ? "MS" : "");
    }

    private String buildDebugLabel(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        short[] sArray = this.context.allWords.type;
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            while (n2 <= nArray[n + 1]) {
                stringBuilder.append(string);
                int n3 = this.sb.input.get(n2);
                stringBuilder.append(this.context.allWords.image[n3]);
                if (TokenTypeUtils.isCommon((int)sArray[n3])) {
                    stringBuilder.append("[S]");
                }
                string = " ";
                ++n2;
            }
            string = "_";
            n += 2;
        }
        return stringBuilder.toString();
    }

    final boolean checkAcceptablePhrase(IntStack intStack) {
        int n;
        assert (intStack.size() > 0);
        short[] sArray = this.context.allWords.type;
        int[] nArray = this.sb.input.buffer;
        if (TokenTypeUtils.isCommon((int)sArray[nArray[intStack.get(0)]])) {
            return false;
        }
        int n2 = intStack.get(intStack.size() - 2);
        int n3 = n = intStack.get(intStack.size() - 1);
        while (n2 <= n && TokenTypeUtils.isCommon((int)sArray[nArray[n]])) {
            --n;
        }
        if (n < n2) {
            return false;
        }
        if (n < n3) {
            intStack.buffer[intStack.size() - 1] = n;
        }
        int n4 = 0;
        n = 0;
        while (n < intStack.size()) {
            n4 += intStack.get(n + 1) - intStack.get(n) + 1;
            n += 2;
        }
        return n4 <= this.maxDescPhraseLength;
    }

    final int effectivePhraseLength(IntStack intStack) {
        int[] nArray = this.sb.input.buffer;
        int n = this.ignoreWordIfInFewerDocs;
        int n2 = (int)(this.ignoreWordIfInHigherDocsPercent * (double)this.documents.size());
        int n3 = 0;
        int n4 = 0;
        while (n4 < intStack.size()) {
            int n5 = intStack.get(n4);
            while (n5 <= intStack.get(n4 + 1)) {
                int n6;
                int n7 = nArray[n5];
                if (!TokenTypeUtils.isCommon((int)this.context.allWords.type[n7]) && (n6 = this.context.allWords.tfByDocument[n7].length / 2) >= n && n6 <= n2) {
                    ++n3;
                }
                ++n5;
            }
            n4 += 2;
        }
        return n3;
    }

    final float baseClusterScore(int n, int n2) {
        double d;
        if (n == 1 && this.singleTermBoost > 0.0) {
            d = this.singleTermBoost;
        } else {
            int n3 = n - this.optimalPhraseLength;
            d = Math.exp((double)(-n3 * n3) / (2.0 * this.optimalPhraseLengthDev * this.optimalPhraseLengthDev));
        }
        return (float)(d * ((double)n2 * this.documentCountBoost));
    }

    private static int indexOf(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4) {
        if (n4 == 0) {
            return 0;
        }
        int n5 = nArray2[n3];
        int n6 = n + (n2 - n4);
        int n7 = n;
        while (n7 <= n6) {
            if (nArray[n7] != n5) {
                while (++n7 <= n6 && nArray[n7] != n5) {
                }
            }
            if (n7 <= n6) {
                int n8 = n7 + 1;
                int n9 = n8 + n4 - 1;
                int n10 = n3 + 1;
                while (n8 < n9 && nArray[n8] == nArray2[n10]) {
                    ++n8;
                    ++n10;
                }
                if (n8 == n9) {
                    return n7 - n;
                }
            }
            ++n7;
        }
        return -1;
    }

    private static final class PhraseCandidate {
        final ClusterCandidate cluster;
        final float coverage;
        boolean selected = true;
        boolean mostGeneral = true;
        boolean mostSpecific = true;

        PhraseCandidate(ClusterCandidate clusterCandidate, float f) {
            this.cluster = clusterCandidate;
            this.coverage = f;
        }
    }
}

