/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.stc;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.text.clustering.MultilingualClusteringDescriptor;
import org.carrot2.text.preprocessing.pipeline.IPreprocessingPipeline;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class STCClusteringAlgorithmDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.clustering.stc.STCClusteringAlgorithm";
    public final String prefix = "STCClusteringAlgorithm";
    public final String title = "Suffix Tree Clustering (STC) algorithm";
    public final String label = "STC Clustering";
    public final String description = "Pretty much as described in: <i>Oren Zamir, Oren Etzioni, Grouper: A Dynamic Clustering Interface to Web Search Results, 1999.</i> Some liberties were taken wherever STC's description was not clear enough or where we thought some improvements could be made.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.clusters);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.documentCountBoost);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.documents);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.ignoreWordIfInFewerDocs);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.ignoreWordIfInHigherDocsPercent);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.maxBaseClusters);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.maxClusters);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.maxDescPhraseLength);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.maxPhraseOverlap);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.maxPhrases);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.mergeStemEquivalentBaseClusters);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.mergeThreshold);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.minBaseClusterScore);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.minBaseClusterSize);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.mostGeneralPhraseCoverage);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.optimalPhraseLength);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.optimalPhraseLengthDev);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.preprocessingPipeline);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.query);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.scoreWeight);
        hashSet.add(STCClusteringAlgorithmDescriptor.attributes.singleTermBoost);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.clusters);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.documentCountBoost);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.documents);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.ignoreWordIfInFewerDocs);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.ignoreWordIfInHigherDocsPercent);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.maxBaseClusters);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.maxClusters);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.maxDescPhraseLength);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.maxPhraseOverlap);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.maxPhrases);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.mergeStemEquivalentBaseClusters);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.mergeThreshold);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.minBaseClusterScore);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.minBaseClusterSize);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.mostGeneralPhraseCoverage);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.optimalPhraseLength);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.optimalPhraseLengthDev);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.preprocessingPipeline);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.query);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.scoreWeight);
        hashSet2.add(STCClusteringAlgorithmDescriptor.attributes.singleTermBoost);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "STCClusteringAlgorithm";
    }

    public String getTitle() {
        return "Suffix Tree Clustering (STC) algorithm";
    }

    public String getLabel() {
        return "STC Clustering";
    }

    public String getDescription() {
        return "Pretty much as described in: <i>Oren Zamir, Oren Etzioni, Grouper: A Dynamic Clustering Interface to Web Search Results, 1999.</i> Some liberties were taken wherever STC's description was not clear enough or where we thought some improvements could be made.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public List<Cluster> clusters() {
            return (List)this.map.get("clusters");
        }

        public AttributeBuilder documentCountBoost(double d) {
            this.map.put("STCClusteringAlgorithm.documentCountBoost", d);
            return this;
        }

        public AttributeBuilder documentCountBoost(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.documentCountBoost", iObjectFactory);
            return this;
        }

        public AttributeBuilder documents(List<Document> list) {
            this.map.put("documents", list);
            return this;
        }

        public AttributeBuilder documents(IObjectFactory<? extends List<Document>> iObjectFactory) {
            this.map.put("documents", iObjectFactory);
            return this;
        }

        public AttributeBuilder ignoreWordIfInFewerDocs(int n) {
            this.map.put("STCClusteringAlgorithm.ignoreWordIfInFewerDocs", n);
            return this;
        }

        public AttributeBuilder ignoreWordIfInFewerDocs(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.ignoreWordIfInFewerDocs", iObjectFactory);
            return this;
        }

        public AttributeBuilder ignoreWordIfInHigherDocsPercent(double d) {
            this.map.put("STCClusteringAlgorithm.ignoreWordIfInHigherDocsPercent", d);
            return this;
        }

        public AttributeBuilder ignoreWordIfInHigherDocsPercent(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.ignoreWordIfInHigherDocsPercent", iObjectFactory);
            return this;
        }

        public AttributeBuilder maxBaseClusters(int n) {
            this.map.put("STCClusteringAlgorithm.maxBaseClusters", n);
            return this;
        }

        public AttributeBuilder maxBaseClusters(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.maxBaseClusters", iObjectFactory);
            return this;
        }

        public AttributeBuilder maxClusters(int n) {
            this.map.put("STCClusteringAlgorithm.maxClusters", n);
            return this;
        }

        public AttributeBuilder maxClusters(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.maxClusters", iObjectFactory);
            return this;
        }

        public AttributeBuilder maxDescPhraseLength(int n) {
            this.map.put("STCClusteringAlgorithm.maxDescPhraseLength", n);
            return this;
        }

        public AttributeBuilder maxDescPhraseLength(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.maxDescPhraseLength", iObjectFactory);
            return this;
        }

        public AttributeBuilder maxPhraseOverlap(double d) {
            this.map.put("STCClusteringAlgorithm.maxPhraseOverlap", d);
            return this;
        }

        public AttributeBuilder maxPhraseOverlap(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.maxPhraseOverlap", iObjectFactory);
            return this;
        }

        public AttributeBuilder maxPhrases(int n) {
            this.map.put("STCClusteringAlgorithm.maxPhrases", n);
            return this;
        }

        public AttributeBuilder maxPhrases(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.maxPhrases", iObjectFactory);
            return this;
        }

        public AttributeBuilder mergeStemEquivalentBaseClusters(boolean bl) {
            this.map.put("STCClusteringAlgorithm.mergeStemEquivalentBaseClusters", bl);
            return this;
        }

        public AttributeBuilder mergeStemEquivalentBaseClusters(IObjectFactory<? extends Boolean> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.mergeStemEquivalentBaseClusters", iObjectFactory);
            return this;
        }

        public AttributeBuilder mergeThreshold(double d) {
            this.map.put("STCClusteringAlgorithm.mergeThreshold", d);
            return this;
        }

        public AttributeBuilder mergeThreshold(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.mergeThreshold", iObjectFactory);
            return this;
        }

        public AttributeBuilder minBaseClusterScore(double d) {
            this.map.put("STCClusteringAlgorithm.minBaseClusterScore", d);
            return this;
        }

        public AttributeBuilder minBaseClusterScore(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.minBaseClusterScore", iObjectFactory);
            return this;
        }

        public AttributeBuilder minBaseClusterSize(int n) {
            this.map.put("STCClusteringAlgorithm.minBaseClusterSize", n);
            return this;
        }

        public AttributeBuilder minBaseClusterSize(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.minBaseClusterSize", iObjectFactory);
            return this;
        }

        public AttributeBuilder mostGeneralPhraseCoverage(double d) {
            this.map.put("STCClusteringAlgorithm.mostGeneralPhraseCoverage", d);
            return this;
        }

        public AttributeBuilder mostGeneralPhraseCoverage(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.mostGeneralPhraseCoverage", iObjectFactory);
            return this;
        }

        public AttributeBuilder optimalPhraseLength(int n) {
            this.map.put("STCClusteringAlgorithm.optimalPhraseLength", n);
            return this;
        }

        public AttributeBuilder optimalPhraseLength(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.optimalPhraseLength", iObjectFactory);
            return this;
        }

        public AttributeBuilder optimalPhraseLengthDev(double d) {
            this.map.put("STCClusteringAlgorithm.optimalPhraseLengthDev", d);
            return this;
        }

        public AttributeBuilder optimalPhraseLengthDev(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.optimalPhraseLengthDev", iObjectFactory);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(IPreprocessingPipeline iPreprocessingPipeline) {
            this.map.put("STCClusteringAlgorithm.preprocessingPipeline", iPreprocessingPipeline);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(Class<?> clazz) {
            this.map.put("STCClusteringAlgorithm.preprocessingPipeline", clazz);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(IObjectFactory<? extends IPreprocessingPipeline> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.preprocessingPipeline", iObjectFactory);
            return this;
        }

        public AttributeBuilder query(String string) {
            this.map.put("query", string);
            return this;
        }

        public AttributeBuilder query(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("query", iObjectFactory);
            return this;
        }

        public AttributeBuilder scoreWeight(double d) {
            this.map.put("STCClusteringAlgorithm.scoreWeight", d);
            return this;
        }

        public AttributeBuilder scoreWeight(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.scoreWeight", iObjectFactory);
            return this;
        }

        public AttributeBuilder singleTermBoost(double d) {
            this.map.put("STCClusteringAlgorithm.singleTermBoost", d);
            return this;
        }

        public AttributeBuilder singleTermBoost(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("STCClusteringAlgorithm.singleTermBoost", iObjectFactory);
            return this;
        }

        public MultilingualClusteringDescriptor.AttributeBuilder multilingualClustering() {
            return MultilingualClusteringDescriptor.attributeBuilder(this.map);
        }
    }

    public static final class Attributes {
        public final AttributeInfo clusters;
        public final AttributeInfo documentCountBoost;
        public final AttributeInfo documents;
        public final AttributeInfo ignoreWordIfInFewerDocs;
        public final AttributeInfo ignoreWordIfInHigherDocsPercent;
        public final AttributeInfo maxBaseClusters;
        public final AttributeInfo maxClusters;
        public final AttributeInfo maxDescPhraseLength;
        public final AttributeInfo maxPhraseOverlap;
        public final AttributeInfo maxPhrases;
        public final AttributeInfo mergeStemEquivalentBaseClusters;
        public final AttributeInfo mergeThreshold;
        public final AttributeInfo minBaseClusterScore;
        public final AttributeInfo minBaseClusterSize;
        public final AttributeInfo mostGeneralPhraseCoverage;
        public final AttributeInfo optimalPhraseLength;
        public final AttributeInfo optimalPhraseLengthDev;
        public final AttributeInfo preprocessingPipeline;
        public final AttributeInfo query;
        public final AttributeInfo scoreWeight;
        public final AttributeInfo singleTermBoost;
        public final MultilingualClusteringDescriptor.Attributes multilingualClustering;

        private Attributes() {
            this.clusters = new AttributeInfo("clusters", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "clusters", "Clusters created by the algorithm.", null, "Clusters created by the algorithm", null, null, null, CommonAttributesDescriptor.attributes.clusters);
            this.documentCountBoost = new AttributeInfo("STCClusteringAlgorithm.documentCountBoost", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "documentCountBoost", "Document count boost. A factor in calculation of the base cluster score, boosting\nthe score depending on the number of documents found in the base cluster.", null, "Document count boost", "A factor in calculation of the base cluster score, boosting the score depending on the number of documents found in the base cluster.", "Base clusters", AttributeLevel.MEDIUM, null);
            this.documents = new AttributeInfo("documents", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "documents", "Documents to cluster.", null, "Documents to cluster", null, null, null, CommonAttributesDescriptor.attributes.documents);
            this.ignoreWordIfInFewerDocs = new AttributeInfo("STCClusteringAlgorithm.ignoreWordIfInFewerDocs", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "ignoreWordIfInFewerDocs", "Minimum word-document recurrences.", null, "Minimum word-document recurrences", null, "Word filtering", AttributeLevel.MEDIUM, null);
            this.ignoreWordIfInHigherDocsPercent = new AttributeInfo("STCClusteringAlgorithm.ignoreWordIfInHigherDocsPercent", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "ignoreWordIfInHigherDocsPercent", "Maximum word-document ratio. A number between 0 and 1, if a word exists in more\nsnippets than this ratio, it is ignored.", null, "Maximum word-document ratio", "A number between 0 and 1, if a word exists in more snippets than this ratio, it is ignored.", "Word filtering", AttributeLevel.MEDIUM, null);
            this.maxBaseClusters = new AttributeInfo("STCClusteringAlgorithm.maxBaseClusters", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "maxBaseClusters", "Maximum base clusters count. Trims the base cluster array after N-th position for\nthe merging phase.", null, "Maximum base clusters count", "Trims the base cluster array after N-th position for the merging phase.", "Base clusters", AttributeLevel.ADVANCED, null);
            this.maxClusters = new AttributeInfo("STCClusteringAlgorithm.maxClusters", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "maxClusters", "Maximum final clusters.", null, "Maximum final clusters", null, "Merging and output", AttributeLevel.BASIC, null);
            this.maxDescPhraseLength = new AttributeInfo("STCClusteringAlgorithm.maxDescPhraseLength", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "maxDescPhraseLength", "Maximum words per label. Base clusters formed by phrases with more words than this\nratio are trimmed.", null, "Maximum words per label", "Base clusters formed by phrases with more words than this ratio are trimmed.", "Labels", AttributeLevel.BASIC, null);
            this.maxPhraseOverlap = new AttributeInfo("STCClusteringAlgorithm.maxPhraseOverlap", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "maxPhraseOverlap", "Maximum cluster phrase overlap.", null, "Maximum cluster phrase overlap", null, "Labels", AttributeLevel.ADVANCED, null);
            this.maxPhrases = new AttributeInfo("STCClusteringAlgorithm.maxPhrases", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "maxPhrases", "Maximum phrases per label. Maximum number of phrases from base clusters promoted\nto the cluster's label.", null, "Maximum phrases per label", "Maximum number of phrases from base clusters promoted to the cluster's label.", "Labels", AttributeLevel.BASIC, null);
            this.mergeStemEquivalentBaseClusters = new AttributeInfo("STCClusteringAlgorithm.mergeStemEquivalentBaseClusters", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "mergeStemEquivalentBaseClusters", "Merge all stem-equivalent base clusters before running the merge phase.", "Merge all stem-equivalent phrases when discovering base clusters", "Merge all stem-equivalent base clusters before running the merge phase", null, "Clusters", AttributeLevel.MEDIUM, null);
            this.mergeThreshold = new AttributeInfo("STCClusteringAlgorithm.mergeThreshold", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "mergeThreshold", "Base cluster merge threshold.", null, "Base cluster merge threshold", null, "Merging and output", AttributeLevel.ADVANCED, null);
            this.minBaseClusterScore = new AttributeInfo("STCClusteringAlgorithm.minBaseClusterScore", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "minBaseClusterScore", "Minimum base cluster score.", null, "Minimum base cluster score", null, "Base clusters", AttributeLevel.ADVANCED, null);
            this.minBaseClusterSize = new AttributeInfo("STCClusteringAlgorithm.minBaseClusterSize", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "minBaseClusterSize", "Minimum documents per base cluster.", null, "Minimum documents per base cluster", null, "Base clusters", AttributeLevel.ADVANCED, null);
            this.mostGeneralPhraseCoverage = new AttributeInfo("STCClusteringAlgorithm.mostGeneralPhraseCoverage", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "mostGeneralPhraseCoverage", "Minimum general phrase coverage. Minimum phrase coverage to appear in cluster\ndescription.", null, "Minimum general phrase coverage", "Minimum phrase coverage to appear in cluster description.", "Labels", AttributeLevel.ADVANCED, null);
            this.optimalPhraseLength = new AttributeInfo("STCClusteringAlgorithm.optimalPhraseLength", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "optimalPhraseLength", "Optimal label length. A factor in calculation of the base cluster score.", null, "Optimal label length", "A factor in calculation of the base cluster score.", "Base clusters", AttributeLevel.BASIC, null);
            this.optimalPhraseLengthDev = new AttributeInfo("STCClusteringAlgorithm.optimalPhraseLengthDev", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "optimalPhraseLengthDev", "Phrase length tolerance. A factor in calculation of the base cluster score.", null, "Phrase length tolerance", "A factor in calculation of the base cluster score.", "Base clusters", AttributeLevel.MEDIUM, null);
            this.preprocessingPipeline = new AttributeInfo("STCClusteringAlgorithm.preprocessingPipeline", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "preprocessingPipeline", "Common preprocessing tasks handler.", null, "Common preprocessing tasks handler", null, null, AttributeLevel.ADVANCED, null);
            this.query = new AttributeInfo("query", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "query", "Query that produced the documents. The query will help the algorithm to create\nbetter clusters. Therefore, providing the query is optional but desirable.", null, "Query that produced the documents", "The query will help the algorithm to create better clusters. Therefore, providing the query is optional but desirable.", null, null, CommonAttributesDescriptor.attributes.query);
            this.scoreWeight = new AttributeInfo("STCClusteringAlgorithm.scoreWeight", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "scoreWeight", "Balance between cluster score and size during cluster sorting. Value equal to 0.0\nwill sort clusters based only on cluster size. Value equal to 1.0\nwill sort clusters based only on cluster score.", "Size-Score sorting ratio", "Balance between cluster score and size during cluster sorting", "Value equal to 0.0 will sort clusters based only on cluster size. Value equal to 1.0 will sort clusters based only on cluster score.", "Clusters", AttributeLevel.MEDIUM, null);
            this.singleTermBoost = new AttributeInfo("STCClusteringAlgorithm.singleTermBoost", "org.carrot2.clustering.stc.STCClusteringAlgorithm", "singleTermBoost", "Single term boost. A factor in calculation of the base cluster score. If greater\nthen zero, single-term base clusters are assigned this value regardless of the\npenalty function.", null, "Single term boost", "A factor in calculation of the base cluster score. If greater then zero, single-term base clusters are assigned this value regardless of the penalty function.", "Base clusters", AttributeLevel.MEDIUM, null);
            this.multilingualClustering = MultilingualClusteringDescriptor.attributes;
        }
    }

    public static class Keys {
        public static final String CLUSTERS = "clusters";
        public static final String DOCUMENT_COUNT_BOOST = "STCClusteringAlgorithm.documentCountBoost";
        public static final String DOCUMENTS = "documents";
        public static final String IGNORE_WORD_IF_IN_FEWER_DOCS = "STCClusteringAlgorithm.ignoreWordIfInFewerDocs";
        public static final String IGNORE_WORD_IF_IN_HIGHER_DOCS_PERCENT = "STCClusteringAlgorithm.ignoreWordIfInHigherDocsPercent";
        public static final String MAX_BASE_CLUSTERS = "STCClusteringAlgorithm.maxBaseClusters";
        public static final String MAX_CLUSTERS = "STCClusteringAlgorithm.maxClusters";
        public static final String MAX_DESC_PHRASE_LENGTH = "STCClusteringAlgorithm.maxDescPhraseLength";
        public static final String MAX_PHRASE_OVERLAP = "STCClusteringAlgorithm.maxPhraseOverlap";
        public static final String MAX_PHRASES = "STCClusteringAlgorithm.maxPhrases";
        public static final String MERGE_STEM_EQUIVALENT_BASE_CLUSTERS = "STCClusteringAlgorithm.mergeStemEquivalentBaseClusters";
        public static final String MERGE_THRESHOLD = "STCClusteringAlgorithm.mergeThreshold";
        public static final String MIN_BASE_CLUSTER_SCORE = "STCClusteringAlgorithm.minBaseClusterScore";
        public static final String MIN_BASE_CLUSTER_SIZE = "STCClusteringAlgorithm.minBaseClusterSize";
        public static final String MOST_GENERAL_PHRASE_COVERAGE = "STCClusteringAlgorithm.mostGeneralPhraseCoverage";
        public static final String OPTIMAL_PHRASE_LENGTH = "STCClusteringAlgorithm.optimalPhraseLength";
        public static final String OPTIMAL_PHRASE_LENGTH_DEV = "STCClusteringAlgorithm.optimalPhraseLengthDev";
        public static final String PREPROCESSING_PIPELINE = "STCClusteringAlgorithm.preprocessingPipeline";
        public static final String QUERY = "query";
        public static final String SCORE_WEIGHT = "STCClusteringAlgorithm.scoreWeight";
        public static final String SINGLE_TERM_BOOST = "STCClusteringAlgorithm.singleTermBoost";

        protected Keys() {
        }
    }
}

