/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.suffixtree;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.LongIntScatterMap;
import com.carrotsearch.hppc.cursors.LongIntCursor;
import org.carrot2.text.suffixtree.ISequence;

public final class SuffixTree {
    private static final int NO_SUFFIX_LINK = Integer.MIN_VALUE;
    private static final int LEAF_STATE = -1;
    public static final int NO_EDGE = -1;
    private static final int ROOT_STATE = 1;
    final ISequence sequence;
    private final int inputSize;
    private IntArrayList states = new IntArrayList();
    private final LongIntScatterMap transitions_map = new LongIntScatterMap();
    private final IntArrayList transitions = new IntArrayList();
    private int s;
    private int k;
    private int i;
    private boolean end_point;
    private final int head;
    private final int root;
    private final int root_transition;
    private final int slots_per_transition;
    private final IStateCallback newStateCallback;

    public SuffixTree(ISequence iSequence, IStateCallback iStateCallback, IProgressCallback iProgressCallback) {
        this.sequence = iSequence;
        this.newStateCallback = iStateCallback;
        this.head = this.createState();
        this.root = this.createState();
        this.setSuffixLink(this.root, this.head);
        assert (1 == this.root);
        this.addTransition(this.root, 0, 0);
        this.slots_per_transition = this.transitions.size();
        this.root_transition = 0;
        this.s = this.root;
        this.inputSize = iSequence.size();
        this.i = 1;
        this.k = 1;
        while (this.i <= this.inputSize) {
            if (iProgressCallback != null) {
                iProgressCallback.next(this.i - 1);
            }
            this.update();
            this.canonize(this.s, this.k, this.i);
            ++this.i;
        }
        int n = this.states.size() - 1;
        while (n >= 0) {
            this.states.set(n, -1);
            --n;
        }
        for (LongIntCursor longIntCursor : this.transitions_map) {
            int n2 = longIntCursor.value;
            int n3 = (int)(longIntCursor.key >>> 32);
            int n4 = this.states.get(n3);
            if (n4 != -1) {
                this.transitions.set(n2 + 3, n4);
            }
            this.states.set(n3, n2);
        }
    }

    private final void update() {
        int n = this.root;
        while (true) {
            int n2 = this.testAndSplit(this.i - 1, this.i);
            if (this.end_point) break;
            this.createTransition(n2, this.i, this.inputSize, this.createNewState(this.i));
            if (n != this.root) {
                this.setSuffixLink(n, n2);
            }
            n = n2;
            this.canonize(this.getSuffixLink(this.s), this.k, this.i - 1);
        }
        if (n != this.root) {
            this.setSuffixLink(n, this.s);
        }
    }

    private final int testAndSplit(int n, int n2) {
        if (this.k <= n) {
            int n3 = this.findTransition(this.s, this.k);
            assert (n3 >= 0);
            int n4 = this.transitions.get(n3 + 1);
            int n5 = this.transitions.get(n3 + 2);
            int n6 = this.transitions.get(n3);
            if (this.sequence.objectAt(n2 - 1) == this.sequence.objectAt(n4 + n - this.k)) {
                this.end_point = true;
                return this.s;
            }
            int n7 = this.createNewState(n4 + n - this.k);
            this.reuseTransition(this.removeTransition(this.s, this.k), this.s, n4, n4 + n - this.k, n7);
            this.createTransition(n7, n4 + n - this.k + 1, n5, n6);
            this.end_point = false;
            return n7;
        }
        this.end_point = this.findTransition(this.s, n2) >= 0;
        return this.s;
    }

    private void canonize(int n, int n2, int n3) {
        if (n3 >= n2) {
            int n4;
            int n5 = this.findTransition(n, n2);
            while (n5 >= 0 && (n4 = this.transitions.get(n5 + 2) - this.transitions.get(n5 + 1)) <= n3 - n2) {
                n2 = n2 + n4 + 1;
                n = this.transitions.get(n5);
                if (n2 > n3) continue;
                n5 = this.findTransition(n, n2);
            }
        }
        this.s = n;
        this.k = n2;
    }

    private void setSuffixLink(int n, int n2) {
        this.states.set(n, n2);
    }

    private int getSuffixLink(int n) {
        int n2 = this.states.get(n);
        assert (n2 != Integer.MIN_VALUE);
        return n2;
    }

    private final int createNewState(int n) {
        int n2 = this.createState();
        if (this.newStateCallback != null) {
            this.newStateCallback.newState(n2, n);
        }
        return n2;
    }

    private final int createState() {
        int n = this.states.size();
        this.states.add(Integer.MIN_VALUE);
        return n;
    }

    private final void createTransition(int n, int n2, int n3, int n4) {
        assert (n2 > 0 && n3 > 0);
        int n5 = this.addTransition(n4, n2, n3);
        this.transitions_map.put(SuffixTree.asLong(n, this.sequence.objectAt(n2 - 1)), n5);
    }

    private final void reuseTransition(int n, int n2, int n3, int n4, int n5) {
        assert (n3 > 0 && n4 > 0);
        this.transitions.set(n, n5);
        this.transitions.set(n + 1, n3);
        this.transitions.set(n + 2, n4);
        this.transitions_map.put(SuffixTree.asLong(n2, this.sequence.objectAt(n3 - 1)), n);
    }

    private final int addTransition(int n, int n2, int n3) {
        int n4 = this.transitions.size();
        this.transitions.add(n);
        this.transitions.add(n2);
        this.transitions.add(n3);
        this.transitions.add(-1);
        return n4;
    }

    private final int findTransition(int n, int n2) {
        return n == this.head ? this.root_transition : this.findEdge(n, this.sequence.objectAt(n2 - 1));
    }

    private int removeTransition(int n, int n2) {
        assert (n != this.head);
        return this.transitions_map.remove(SuffixTree.asLong(n, this.sequence.objectAt(n2 - 1)));
    }

    private static final long asLong(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public final int getTransitionsCount() {
        return this.transitions.size() / this.slots_per_transition - 1;
    }

    public final int getStatesCount() {
        return this.states.size() - 1;
    }

    public boolean containsSuffix(ISequence iSequence) {
        int n = this.root;
        int n2 = 0;
        int n3;
        while ((n3 = this.findEdge(n, iSequence.objectAt(n2))) >= 0) {
            int n4 = this.getStartIndex(n3);
            int n5 = this.getEndIndex(n3) + 1;
            while (n2 < iSequence.size() && n4 < n5) {
                if (iSequence.objectAt(n2) != this.sequence.objectAt(n4)) {
                    return false;
                }
                ++n4;
                ++n2;
            }
            if (n2 == iSequence.size()) {
                return n4 == this.inputSize;
            }
            n = this.getToState(n3);
        }
        return false;
    }

    public final void visit(IVisitor iVisitor) {
        this.visitState(this.root, iVisitor);
    }

    public final void visitState(int n, IVisitor iVisitor) {
        if (iVisitor.pre(n)) {
            int n2 = this.firstEdge(n);
            while (n2 != -1) {
                int n3 = this.transitions.get(n2);
                if (iVisitor.edge(n, n3, this.getStartIndex(n2), this.getEndIndex(n2))) {
                    this.visitState(n3, iVisitor);
                }
                n2 = this.nextEdge(n2);
            }
            iVisitor.post(n);
        }
    }

    public int getRootState() {
        return this.root;
    }

    public final boolean isLeaf(int n) {
        return this.states.get(n) == -1;
    }

    public final int firstEdge(int n) {
        return this.states.get(n);
    }

    public final int nextEdge(int n) {
        return this.transitions.get(n + 3);
    }

    public final int findEdge(int n, int n2) {
        return this.transitions_map.getOrDefault(SuffixTree.asLong(n, n2), -1);
    }

    public int getToState(int n) {
        return this.transitions.get(n);
    }

    public int getStartIndex(int n) {
        return this.transitions.get(n + 1) - 1;
    }

    public int getEndIndex(int n) {
        return this.transitions.get(n + 2) - 1;
    }

    public static interface IProgressCallback {
        public void next(int var1);
    }

    public static interface IStateCallback {
        public void newState(int var1, int var2);
    }

    public static interface IVisitor {
        public boolean pre(int var1);

        public void post(int var1);

        public boolean edge(int var1, int var2, int var3, int var4);
    }

    public static class VisitorAdapter
    implements IVisitor {
        @Override
        public boolean pre(int n) {
            return true;
        }

        @Override
        public void post(int n) {
        }

        @Override
        public boolean edge(int n, int n2, int n3, int n4) {
            return true;
        }
    }
}

