/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.etools;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.apache.http.client.HttpResponseException;
import org.carrot2.core.Document;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.etools.IpBannedException;
import org.carrot2.source.xml.RemoteXmlSimpleSearchEngineBase;
import org.carrot2.util.StringUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.constraint.IntRange;
import org.carrot2.util.resource.ClassResource;
import org.carrot2.util.resource.IResource;

@Bindable(prefix="EToolsDocumentSource")
public class EToolsDocumentSource
extends RemoteXmlSimpleSearchEngineBase {
    @Input
    @Processing
    @Internal
    @Attribute
    @Label(value="Service URL")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public String serviceUrlBase = "http://www.etools.ch/partnerSearch.do";
    @Input
    @Processing
    @Attribute
    @Label(value="Country")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Filtering")
    public Country country = Country.ALL;
    @Input
    @Processing
    @Attribute
    @Label(value="Language")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Filtering")
    public Language language = Language.ENGLISH;
    @Input
    @Processing
    @Attribute
    @IntRange(min=0)
    @Label(value="Timeout")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public int timeout = 4000;
    @Input
    @Processing
    @Attribute
    @Label(value="Data sources")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public DataSources dataSources = DataSources.ALL;
    @Input
    @Processing
    @Attribute
    @Label(value="Safe search")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Filtering")
    public boolean safeSearch = false;
    @Input
    @Processing
    @Attribute
    @Label(value="Site restriction")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Filtering")
    public String site = null;
    @Input
    @Processing
    @Attribute
    @Internal
    @Label(value="Partner ID")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public String partnerId = "Carrot2";
    @Input
    @Processing
    @Attribute
    @Label(value="Customer ID")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Service")
    public String customerId = "";
    private static final int MAX_DATA_SOURCE_RESULTS = 40;
    private static final int FASTEST_SOURCES_COUNT = 5;
    private static final int ALL_SOURCES_COUNT = 10;

    protected IResource getXsltResource() {
        return new ClassResource(EToolsDocumentSource.class, "etools-to-c2.xsl");
    }

    protected String buildServiceUrl() {
        String string = this.serviceUrlBase;
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return String.valueOf(string) + "?partner=" + this.partnerId + "&query=" + StringUtils.urlEncodeWrapException((String)this.query, (String)"UTF-8") + "&dataSourceResults=" + Integer.toString(this.getDataSourceResultsCount()) + "&maxRecords=" + this.results + "&language=" + this.language.getCode() + "&timeout=" + Integer.toString(this.timeout) + "&dataSources=" + this.dataSources.getCode() + "&safeSearch=" + Boolean.toString(this.safeSearch) + "&country=" + this.country.getCode() + "&customerId=" + StringUtils.urlEncodeWrapException((String)this.customerId, (String)"UTF-8");
    }

    protected SearchEngineResponse fetchSearchResponse() throws Exception {
        try {
            return super.fetchSearchResponse();
        }
        catch (Exception exception) {
            HttpResponseException httpResponseException;
            int n;
            if (exception instanceof HttpResponseException && ((n = (httpResponseException = (HttpResponseException)exception).getStatusCode()) == 302 || n == 403)) {
                throw new IpBannedException((Exception)httpResponseException);
            }
            throw exception;
        }
    }

    int getDataSourceResultsCount() {
        int n;
        int n2 = n = DataSources.ALL.equals((Object)this.dataSources) ? 10 : 5;
        if (this.results == 0) {
            return 0;
        }
        int n3 = this.results / n;
        return Math.min(((n3 + 9) / 10 + 1) * 10, 40);
    }

    public void beforeProcessing() throws ProcessingException {
        super.beforeProcessing();
        if (!Strings.isNullOrEmpty((String)this.site)) {
            Object[] objectArray = this.site.split(",\\s*");
            int n = 0;
            while (n < objectArray.length) {
                if (!objectArray[n].startsWith("site:")) {
                    objectArray[n] = "site:" + (String)objectArray[n];
                }
                ++n;
            }
            this.query = "(" + this.query + ") AND (" + Joiner.on((String)" OR ").join(objectArray) + ")";
            if (this.query.length() > 2048) {
                throw new ProcessingException("Query length must not exceed 2048 characters");
            }
        }
    }

    protected void afterFetch(SearchEngineResponse searchEngineResponse) {
        if (this.language != Language.ALL) {
            for (Document document : searchEngineResponse.results) {
                document.setLanguage(this.language.toLanguageCode());
            }
        }
    }

    public static enum Country {
        ALL("web"),
        AUSTRIA("AT"),
        FRANCE("FR"),
        GERMANY("DE"),
        GREAT_BRITAIN("GB"),
        ITALY("IT"),
        LICHTENSTEIN("LI"),
        SPAIN("ES"),
        SWITZERLAND("CH");

        private String code;

        private Country(String string2) {
            this.code = string2;
        }

        public String toString() {
            return StringUtils.identifierToHumanReadable((String)this.name());
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum DataSources {
        ALL("all"),
        FASTEST("fastest");

        private String code;

        private DataSources(String string2) {
            this.code = string2;
        }

        public String toString() {
            return StringUtils.identifierToHumanReadable((String)this.name());
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum Language {
        ALL("all"),
        ENGLISH("en"),
        FRENCH("fr"),
        GERMAN("de"),
        ITALIAN("it"),
        SPANISH("es");

        private static final Map<Language, LanguageCode> TO_LANGUAGE_CODE;
        private String code;

        static {
            EnumMap enumMap = Maps.newEnumMap(Language.class);
            enumMap.put(ENGLISH, LanguageCode.ENGLISH);
            enumMap.put(FRENCH, LanguageCode.FRENCH);
            enumMap.put(GERMAN, LanguageCode.GERMAN);
            enumMap.put(ITALIAN, LanguageCode.ITALIAN);
            enumMap.put(SPANISH, LanguageCode.SPANISH);
            TO_LANGUAGE_CODE = Collections.unmodifiableMap(enumMap);
        }

        private Language(String string2) {
            this.code = string2;
        }

        public String toString() {
            return StringUtils.identifierToHumanReadable((String)this.name());
        }

        public String getCode() {
            return this.code;
        }

        public LanguageCode toLanguageCode() {
            return TO_LANGUAGE_CODE.get((Object)this);
        }
    }
}

