/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.synthetic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class ByUrlClusteringAlgorithmDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.clustering.synthetic.ByUrlClusteringAlgorithm";
    public final String prefix = "";
    public final String title = "Hierarchically clusters documents according to their content URLs";
    public final String label = "By URL Clustering";
    public final String description = "<code>Document.CONTENT_URL</code> property will be used to obtain a document's URL. <p> Groups at the top level of the hierarchy will correspond to the last segments of the URLs, usually domain suffixes, such as \".com\" or \".co.uk\". Subgroups will be created based on further segments of the URLs, very often domains subdomains, e.g. \"yahoo.com\", \"bbc.co.uk\" and then e.g. \"mail.yahoo.com\", \"news.yahoo.com\". The \"www\" segment of the URLs will be ignored. <p> Clusters will be ordered by size (number of documents) descendingly; in case of equal sizes, alphabetically by URL, see <code>Cluster.BY_REVERSED_SIZE_AND_LABEL_COMPARATOR</code>.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(ByUrlClusteringAlgorithmDescriptor.attributes.clusters);
        hashSet.add(ByUrlClusteringAlgorithmDescriptor.attributes.documents);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(ByUrlClusteringAlgorithmDescriptor.attributes.clusters);
        hashSet2.add(ByUrlClusteringAlgorithmDescriptor.attributes.documents);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "";
    }

    public String getTitle() {
        return "Hierarchically clusters documents according to their content URLs";
    }

    public String getLabel() {
        return "By URL Clustering";
    }

    public String getDescription() {
        return "<code>Document.CONTENT_URL</code> property will be used to obtain a document's URL. <p> Groups at the top level of the hierarchy will correspond to the last segments of the URLs, usually domain suffixes, such as \".com\" or \".co.uk\". Subgroups will be created based on further segments of the URLs, very often domains subdomains, e.g. \"yahoo.com\", \"bbc.co.uk\" and then e.g. \"mail.yahoo.com\", \"news.yahoo.com\". The \"www\" segment of the URLs will be ignored. <p> Clusters will be ordered by size (number of documents) descendingly; in case of equal sizes, alphabetically by URL, see <code>Cluster.BY_REVERSED_SIZE_AND_LABEL_COMPARATOR</code>.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public List<Cluster> clusters() {
            return (List)this.map.get("clusters");
        }

        public AttributeBuilder documents(List<Document> list) {
            this.map.put("documents", list);
            return this;
        }

        public AttributeBuilder documents(IObjectFactory<? extends List<Document>> iObjectFactory) {
            this.map.put("documents", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo clusters;
        public final AttributeInfo documents;

        private Attributes() {
            this.clusters = new AttributeInfo("clusters", "org.carrot2.clustering.synthetic.ByUrlClusteringAlgorithm", "clusters", "Clusters created by the algorithm.", null, "Clusters created by the algorithm", null, null, null, CommonAttributesDescriptor.attributes.clusters);
            this.documents = new AttributeInfo("documents", "org.carrot2.clustering.synthetic.ByUrlClusteringAlgorithm", "documents", "Documents to cluster.", null, "Documents to cluster", null, null, null, CommonAttributesDescriptor.attributes.documents);
        }
    }

    public static class Keys {
        public static final String CLUSTERS = "clusters";
        public static final String DOCUMENTS = "documents";

        protected Keys() {
        }
    }
}

