/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors.lucene;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.carrot2.workbench.core.helpers.DisposeBin;
import org.carrot2.workbench.core.helpers.GUIFactory;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.editors.AttributeEditorAdapter;
import org.carrot2.workbench.editors.AttributeEditorInfo;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.IAttributeEditor;
import org.carrot2.workbench.editors.impl.EditorsPlugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class IndexDirectoryEditor
extends AttributeEditorAdapter {
    public static final String PREF_LAST_SELECTED_LUCENE_DIR = "resource-editor.last-selected-lucene-dir";
    private DisposeBin disposeBin = new DisposeBin();
    private Text resourceInfo;
    private Directory current = null;

    protected AttributeEditorInfo init(Map<String, Object> map) {
        return new AttributeEditorInfo(1, false);
    }

    public void createEditor(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)GUIFactory.editorGridData().grab(true, false).span(n, 1).create());
        GridLayout gridLayout = GUIFactory.zeroMarginGridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 3;
        composite2.setLayout((Layout)gridLayout);
        this.createTextBox(composite2);
        this.createFileButton(composite2);
    }

    private void createTextBox(Composite composite) {
        this.resourceInfo = new Text(composite, 526348);
        GridData gridData = GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).align(4, 0x1000000).create();
        this.resourceInfo.setLayoutData((Object)gridData);
    }

    private void createFileButton(Composite composite) {
        Image image = EditorsPlugin.getImageDescriptor((String)"icons/open_folder.gif").createImage();
        this.disposeBin.add(new Resource[]{image});
        Button button = new Button(composite, 0x1000008);
        button.setImage(image);
        button.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).create());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IndexDirectoryEditor.this.openIndexDialog();
            }
        });
    }

    private void openIndexDialog() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.resourceInfo.getShell());
        if (this.current != null && this.current instanceof FSDirectory) {
            directoryDialog.setFilterPath(((FSDirectory)this.current).getDirectory().toAbsolutePath().toString());
        } else {
            directoryDialog.setFilterPath(EditorsPlugin.getDefault().getPreferenceStore().getString(PREF_LAST_SELECTED_LUCENE_DIR));
        }
        String string = directoryDialog.open();
        if (string != null) {
            try {
                Path path = Paths.get(string, new String[0]);
                EditorsPlugin.getDefault().getPreferenceStore().setValue(PREF_LAST_SELECTED_LUCENE_DIR, path.toAbsolutePath().toString());
                this.setValue(FSDirectory.open((Path)path));
            }
            catch (Exception exception) {
                Utils.logError((String)("Could not open index in directory: " + string), (Throwable)exception, (boolean)true);
            }
        }
    }

    public void setValue(Object object) {
        if (object == this.current) {
            return;
        }
        if (!(object instanceof Directory)) {
            return;
        }
        this.current = (Directory)object;
        String string = this.current == null ? "" : (this.current instanceof FSDirectory ? ((FSDirectory)this.current).getDirectory().toAbsolutePath().toString() : this.current.getClass().getSimpleName());
        this.resourceInfo.setText(string);
        this.fireAttributeChanged(new AttributeEvent((IAttributeEditor)this));
    }

    public Object getValue() {
        return this.current;
    }

    public void dispose() {
        this.disposeBin.dispose();
    }
}

