/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.editors.lucene;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.store.Directory;
import org.carrot2.source.lucene.LuceneDocumentSource;
import org.carrot2.util.attribute.AttributeUtils;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.editors.AttributeEditorInfo;
import org.carrot2.workbench.editors.AttributeEvent;
import org.carrot2.workbench.editors.AttributeListenerAdapter;
import org.carrot2.workbench.editors.IAttributeListener;
import org.carrot2.workbench.editors.impl.MappedValueComboEditor;

public final class LuceneFieldSelectorEditor
extends MappedValueComboEditor {
    private static final String dirKey = AttributeUtils.getKey(LuceneDocumentSource.class, (String)"directory");

    public AttributeEditorInfo init(Map<String, Object> map) {
        this.valueRequired = false;
        this.anyValueAllowed = true;
        this.refreshFields(map.get(dirKey));
        this.eventProvider.addAttributeListener((IAttributeListener)new AttributeListenerAdapter(){

            public void valueChanged(AttributeEvent attributeEvent) {
                if (StringUtils.equals((String)attributeEvent.key, (String)dirKey)) {
                    LuceneFieldSelectorEditor.this.refreshFields(attributeEvent.value);
                }
            }
        });
        return new AttributeEditorInfo(1, false);
    }

    private void refreshFields(Object object) {
        HashBiMap hashBiMap = HashBiMap.create();
        ArrayList arrayList = Lists.newArrayList();
        if (object != null && object instanceof Directory) {
            try {
                Directory directory = (Directory)object;
                try (DirectoryReader directoryReader = DirectoryReader.open((Directory)directory);){
                    ArrayList arrayList2 = Lists.newArrayList();
                    for (Object object2 : MultiFields.getMergedFieldInfos((IndexReader)directoryReader)) {
                        arrayList2.add(object2.name);
                    }
                    Collections.sort(arrayList2);
                    for (Object object2 : arrayList2) {
                        hashBiMap.put(object2, object2);
                        arrayList.add(object2);
                    }
                }
            }
            catch (Exception exception) {
                Utils.logError((String)"Index access error.", (Throwable)exception, (boolean)false);
            }
        }
        super.setMappedValues((BiMap)hashBiMap, (List)arrayList);
    }

    public void setValue(Object object) {
        super.setValue(object);
    }
}

