/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.log4j;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;

public class BufferingAppender
extends WriterAppender {
    StringWriter writer = new StringWriter();

    private BufferingAppender(StringWriter stringWriter) {
        super((Layout)new SimpleLayout(), (Writer)stringWriter);
        this.writer = stringWriter;
        super.setImmediateFlush(true);
    }

    public BufferingAppender() {
        this(new StringWriter());
    }

    public static BufferingAppender attach(String string) {
        BufferingAppender bufferingAppender = new BufferingAppender();
        BufferingAppender.resolve(string).addAppender((Appender)bufferingAppender);
        return bufferingAppender;
    }

    public static BufferingAppender attachToRootLogger() {
        return BufferingAppender.attach(null);
    }

    private static Logger resolve(String string) {
        if (string == null || string.length() == 0) {
            return Logger.getRootLogger();
        }
        return Logger.getLogger((String)string);
    }

    public static void detach(String string, BufferingAppender bufferingAppender) {
        BufferingAppender.resolve(string).removeAppender((Appender)bufferingAppender);
    }

    public static void detachFromRootLogger(BufferingAppender bufferingAppender) {
        BufferingAppender.detach(null, bufferingAppender);
    }

    public void clear() {
        this.writer.getBuffer().setLength(0);
    }

    public String getBuffer() {
        return this.writer.toString();
    }
}

