/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.ambient;

import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.CommonAttributes;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.ambient.FubDocumentSource;
import org.carrot2.source.ambient.FubTestCollection;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.IntRange;

@Bindable(prefix="AmbientDocumentSource", inherit={CommonAttributes.class})
public class AmbientDocumentSource
extends FubDocumentSource {
    static final FubTestCollection DATA = new FubTestCollection("/ambient");
    static final int TOPIC_COUNT = 44;
    static final int MAX_RESULTS_PER_TOPIC = 100;
    @Input
    @Processing
    @Attribute
    @Required
    @Group(value="Topic ID")
    @Level(value=AttributeLevel.BASIC)
    public AmbientTopic topic = AmbientTopic.AIDA;
    @Processing
    @Input
    @Attribute(key="results", inherit=true)
    @IntRange(min=1, max=100)
    public int results = 100;
    @Processing
    @Output
    @Attribute(key="results-total", inherit=true)
    public long resultsTotal = 100L;

    public void process() throws ProcessingException {
        this.query = this.topic.query;
        this.processInternal(DATA, this.topic.getTopicId(), this.results);
    }

    public static String getTopicLabel(String string) {
        return DATA.getTopicLabel(string);
    }

    public static enum AmbientTopic {
        AIDA(1, "Aida"),
        B_52(2, "B-52"),
        BEAGLE(3, "Beagle"),
        BRONX(4, "Bronx"),
        CAIN(5, "Cain"),
        CAMEL(6, "Camel"),
        CORAL_SEA(7, "Coral Sea"),
        CUBE(8, "Cube"),
        EOS(9, "Eos"),
        EXCALIBUR(10, "Excalibur"),
        FAHRENHEIT(11, "Fahrenheit"),
        GLOBE(12, "Globe"),
        HORNET(13, "Hornet"),
        INDIGO(14, "Indigo"),
        IWO_JIMA(15, "Iwo Jima"),
        JAGUAR(16, "Jaguar"),
        LA_PLATA(17, "La Plata"),
        LABYRINTH(18, "Labyrinth"),
        LANDAU(19, "Landau"),
        LIFE_ON_MARS(20, "Life on Mars"),
        LOCUST(21, "Locust"),
        MAGIC_MOUNTAIN(22, "Magic Mountain"),
        MATADOR(23, "Matador"),
        METAMORPHOSIS(24, "Metamorphosis"),
        MINOTAUR(25, "Minotaur"),
        MIRA(26, "Mira"),
        MIRAGE(27, "Mirage"),
        MONTE_CARLO(28, "Monte Carlo"),
        OPPENHEIM(29, "Oppenheim"),
        OUT_OF_CONTROL(30, "Out of Control"),
        PELICAN(31, "Pelican"),
        PURPLE_HAZE(32, "Purple Haze"),
        RAAM(33, "Raam"),
        RHEA(34, "Rhea"),
        SCORPION(35, "Scorpion"),
        THE_LITTLE_MERMAID(36, "The Little Mermaid"),
        TORTUGA(37, "Tortuga"),
        URANIA(38, "Urania"),
        WINK(39, "Wink"),
        XANADU(40, "Xanadu"),
        ZEBRA(41, "Zebra"),
        ZENITH(42, "Zenith"),
        ZODIAC(43, "Zodiac"),
        ZOMBIE(44, "Zombie");

        private int topicId;
        private String query;

        private AmbientTopic(int n2, String string2) {
            this.topicId = n2;
            this.query = string2;
        }

        public int getTopicId() {
            return this.topicId;
        }

        public String toString() {
            return this.query;
        }
    }
}

