/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.ambient;

import java.util.List;
import java.util.Set;
import org.carrot2.core.Document;
import org.carrot2.core.IDocumentSource;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.ProcessingComponentBase;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.CommonAttributes;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.ambient.FubTestCollection;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.attribute.constraint.IntRange;

@Bindable(prefix="FubDocumentSource", inherit={CommonAttributes.class})
public class FubDocumentSource
extends ProcessingComponentBase
implements IDocumentSource {
    protected static final String TOPIC_ID = "Topic ID";
    @Processing
    @Output
    @Attribute(key="documents", inherit=true)
    @Internal
    public List<Document> documents;
    @Processing
    @Output
    @Attribute
    @Group(value="Topic ID")
    @Level(value=AttributeLevel.ADVANCED)
    public Set<Object> topicIds;
    @Processing
    @Output
    @Attribute(key="query", inherit=true)
    public String query;
    @Input
    @Processing
    @Attribute
    @IntRange(min=1)
    @Group(value="Filtering")
    @Level(value=AttributeLevel.MEDIUM)
    public int minTopicSize = 1;
    @Input
    @Processing
    @Attribute
    @Group(value="Filtering")
    @Level(value=AttributeLevel.MEDIUM)
    public boolean includeDocumentsWithoutTopic = false;

    protected void processInternal(FubTestCollection fubTestCollection, int n, int n2) throws ProcessingException {
        this.documents = fubTestCollection.getDocumentsForTopic(n, n2, this.minTopicSize, this.includeDocumentsWithoutTopic);
        for (Document document : this.documents) {
            document.setLanguage(LanguageCode.ENGLISH);
        }
    }
}

