/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.ambient;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class FubDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.ambient.FubDocumentSource";
    public final String prefix = "FubDocumentSource";
    public final String title = "A base document source for test collections developed at Fondazione Ugo Bordoni";
    public final String label = "";
    public final String description = "";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(FubDocumentSourceDescriptor.attributes.documents);
        hashSet.add(FubDocumentSourceDescriptor.attributes.includeDocumentsWithoutTopic);
        hashSet.add(FubDocumentSourceDescriptor.attributes.minTopicSize);
        hashSet.add(FubDocumentSourceDescriptor.attributes.query);
        hashSet.add(FubDocumentSourceDescriptor.attributes.topicIds);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(FubDocumentSourceDescriptor.attributes.documents);
        hashSet2.add(FubDocumentSourceDescriptor.attributes.includeDocumentsWithoutTopic);
        hashSet2.add(FubDocumentSourceDescriptor.attributes.minTopicSize);
        hashSet2.add(FubDocumentSourceDescriptor.attributes.query);
        hashSet2.add(FubDocumentSourceDescriptor.attributes.topicIds);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "FubDocumentSource";
    }

    public String getTitle() {
        return "A base document source for test collections developed at Fondazione Ugo Bordoni";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public List<Document> documents() {
            return (List)this.map.get("documents");
        }

        public AttributeBuilder includeDocumentsWithoutTopic(boolean bl) {
            this.map.put("FubDocumentSource.includeDocumentsWithoutTopic", bl);
            return this;
        }

        public AttributeBuilder includeDocumentsWithoutTopic(IObjectFactory<? extends Boolean> iObjectFactory) {
            this.map.put("FubDocumentSource.includeDocumentsWithoutTopic", iObjectFactory);
            return this;
        }

        public AttributeBuilder minTopicSize(int n) {
            this.map.put("FubDocumentSource.minTopicSize", n);
            return this;
        }

        public AttributeBuilder minTopicSize(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("FubDocumentSource.minTopicSize", iObjectFactory);
            return this;
        }

        public String query() {
            return (String)this.map.get("query");
        }

        public Set<Object> topicIds() {
            return (Set)this.map.get("FubDocumentSource.topicIds");
        }
    }

    public static final class Attributes {
        public final AttributeInfo documents;
        public final AttributeInfo includeDocumentsWithoutTopic;
        public final AttributeInfo minTopicSize;
        public final AttributeInfo query;
        public final AttributeInfo topicIds;

        private Attributes() {
            this.documents = new AttributeInfo("documents", "org.carrot2.source.ambient.FubDocumentSource", "documents", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.documents);
            this.includeDocumentsWithoutTopic = new AttributeInfo("FubDocumentSource.includeDocumentsWithoutTopic", "org.carrot2.source.ambient.FubDocumentSource", "includeDocumentsWithoutTopic", "Include documents without topics.", null, "Include documents without topics", null, "Filtering", AttributeLevel.MEDIUM, null);
            this.minTopicSize = new AttributeInfo("FubDocumentSource.minTopicSize", "org.carrot2.source.ambient.FubDocumentSource", "minTopicSize", "Minimum topic size. Documents belonging to a topic with fewer documents than\nminimum topic size will not be returned.", null, "Minimum topic size", "Documents belonging to a topic with fewer documents than minimum topic size will not be returned.", "Filtering", AttributeLevel.MEDIUM, null);
            this.query = new AttributeInfo("query", "org.carrot2.source.ambient.FubDocumentSource", "query", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.query);
            this.topicIds = new AttributeInfo("FubDocumentSource.topicIds", "org.carrot2.source.ambient.FubDocumentSource", "topicIds", "Topics and subtopics covered in the output documents. The set is computed for the\noutput {@link org.carrot2.source.ambient.FubDocumentSource#documents} and it may vary for the same main topic based e.g. on the\nrequested number of requested results or {@link org.carrot2.source.ambient.FubDocumentSource#minTopicSize}.", null, "Topics and subtopics covered in the output documents", "The set is computed for the output <code>org.carrot2.source.ambient.FubDocumentSource.documents</code> and it may vary for the same main topic based e.g. on the requested number of requested results or <code>org.carrot2.source.ambient.FubDocumentSource.minTopicSize</code>.", "Topic ID", AttributeLevel.ADVANCED, null);
        }
    }

    public static class Keys {
        public static final String DOCUMENTS = "documents";
        public static final String INCLUDE_DOCUMENTS_WITHOUT_TOPIC = "FubDocumentSource.includeDocumentsWithoutTopic";
        public static final String MIN_TOPIC_SIZE = "FubDocumentSource.minTopicSize";
        public static final String QUERY = "query";
        public static final String TOPIC_IDS = "FubDocumentSource.topicIds";

        protected Keys() {
        }
    }
}

