/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.ambient;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Document;
import org.carrot2.core.ProcessingException;
import org.carrot2.source.ambient.AmbientDocumentSource;
import org.carrot2.util.CloseableUtils;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.MapUtils;
import org.carrot2.util.resource.ClassResource;
import org.carrot2.util.resource.IResource;

class FubTestCollection {
    int topicCount;
    final Map<Integer, List<Document>> documentsByTopicId;
    final Map<String, Integer> subtopicSizes;
    final Map<String, String> subtopicLabels;

    public FubTestCollection(String string) {
        int[][] nArray = this.loadSubtopicMapping((IResource)new ClassResource(AmbientDocumentSource.class, String.valueOf(string) + "/STRel.txt"));
        this.documentsByTopicId = FubTestCollection.loadDocuments((IResource)new ClassResource(AmbientDocumentSource.class, String.valueOf(string) + "/results.txt"), nArray);
        this.subtopicSizes = FubTestCollection.prepareSubtopicSizes(nArray);
        this.subtopicLabels = FubTestCollection.loadSubtopicLabels((IResource)new ClassResource(AmbientDocumentSource.class, String.valueOf(string) + "/subTopics.txt"));
    }

    protected int getTopicCount() {
        return this.topicCount;
    }

    protected List<Document> getDocumentsForTopic(int n, int n2, final int n3, final boolean bl) throws ProcessingException {
        ArrayList arrayList = Lists.newArrayList((Iterable)Collections2.filter((Collection)this.documentsByTopicId.get(n), (Predicate)new Predicate<Document>(){

            public boolean apply(Document document) {
                String string = FubTestCollection.getTopic(document);
                return FubTestCollection.this.subtopicSizes.get(string) >= n3 && (bl || !string.endsWith(".0"));
            }
        }));
        if (arrayList.size() >= n2) {
            return arrayList.subList(0, n2);
        }
        return arrayList;
    }

    protected Set<Object> getTopicIds(List<Document> list) {
        HashSet hashSet = Sets.newHashSet();
        for (Document document : list) {
            hashSet.addAll((Collection)document.getField("partitions"));
        }
        return hashSet;
    }

    protected static String getTopic(Document document) {
        return (String)((List)document.getField("partitions")).get(0);
    }

    String getTopicLabel(String string) {
        return this.subtopicLabels.get(string);
    }

    private static Map<String, String> loadSubtopicLabels(IResource iResource) {
        HashMap hashMap = Maps.newHashMap();
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(iResource.open(), "UTF-8"));
                String string = bufferedReader.readLine();
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split("\\t");
                    if (stringArray.length <= 1) continue;
                    hashMap.put(stringArray[0], stringArray[1]);
                }
            }
            catch (Exception exception) {
                throw ExceptionUtils.wrapAsRuntimeException((Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                CloseableUtils.close(bufferedReader);
            }
            throw throwable;
        }
        if (bufferedReader != null) {
            CloseableUtils.close((Closeable)bufferedReader);
        }
        return hashMap;
    }

    private static Map<String, Integer> prepareSubtopicSizes(int[][] nArray) {
        HashMap hashMap = Maps.newHashMap();
        int n = 1;
        while (n < nArray.length) {
            int n2 = 1;
            while (n2 < nArray[n].length) {
                MapUtils.increment((Map)hashMap, (Object)FubTestCollection.buildTopicId(n, nArray[n][n2]));
                ++n2;
            }
            ++n;
        }
        return hashMap;
    }

    private static Map<Integer, List<Document>> loadDocuments(IResource iResource, int[][] nArray) {
        Object object;
        HashMap hashMap = Maps.newHashMap();
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(iResource.open(), "UTF-8"));
                object = bufferedReader.readLine();
                while ((object = bufferedReader.readLine()) != null) {
                    Object object2 = ((String)object).split("\\t");
                    String[] stringArray = object2[0].split("\\.");
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    Document document = new Document();
                    document.setField("url", (Object)object2[1]);
                    document.setField("title", (Object)object2[2]);
                    if (((String[])object2).length > 3) {
                        document.setField("snippet", (Object)object2[3]);
                    }
                    document.setField("partitions", (Object)ImmutableList.of((Object)FubTestCollection.buildTopicId(n, nArray[n].length > n2 ? nArray[n][n2] : 0)));
                    List list = (List)hashMap.get(n);
                    if (list == null) {
                        list = Lists.newArrayList();
                        hashMap.put(n, list);
                    }
                    list.add(document);
                }
            }
            catch (Exception exception) {
                throw ExceptionUtils.wrapAsRuntimeException((Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            CloseableUtils.close(bufferedReader);
            throw throwable;
        }
        CloseableUtils.close((Closeable)bufferedReader);
        object = Lists.newArrayList();
        for (Object object2 : hashMap.values()) {
            object.addAll(object2);
        }
        Document.assignDocumentIds((Collection)object);
        return hashMap;
    }

    private static String buildTopicId(int n, int n2) {
        return String.valueOf(n) + "." + n2;
    }

    private int[][] loadSubtopicMapping(IResource iResource) {
        int n;
        Object object;
        HashMap hashMap = Maps.newHashMap();
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(iResource.open(), "UTF-8"));
                bufferedReader.readLine();
                while ((object = bufferedReader.readLine()) != null) {
                    String[] stringArray = ((String)object).split("[\\t.]");
                    int n2 = Integer.parseInt(stringArray[0]);
                    n = Integer.parseInt(stringArray[1]);
                    int n3 = Integer.parseInt(stringArray[3]);
                    Map map = (Map)hashMap.get(n2);
                    if (map == null) {
                        map = Maps.newHashMap();
                        hashMap.put(n2, map);
                    }
                    map.put(n3, n);
                }
            }
            catch (Exception exception) {
                throw ExceptionUtils.wrapAsRuntimeException((Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                CloseableUtils.close(bufferedReader);
            }
            throw throwable;
        }
        if (bufferedReader != null) {
            CloseableUtils.close((Closeable)bufferedReader);
        }
        this.topicCount = hashMap.size();
        object = new int[hashMap.size() + 1][];
        int n4 = 1;
        while (n4 < ((Object)object).length) {
            Map map = (Map)hashMap.get(n4);
            object[n4] = new int[(Integer)Collections.max(map.keySet()) + 1];
            n = 1;
            while (n < ((Object)object[n4]).length) {
                Integer n5 = (Integer)map.get(n);
                if (n5 != null) {
                    object[n4][n] = n5;
                }
                ++n;
            }
            ++n4;
        }
        return object;
    }
}

