/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.xml;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.RedirectStrategy;
import org.carrot2.core.HttpAuthHub;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.ProcessingResult;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.SimpleSearchEngine;
import org.carrot2.source.xml.XmlDocumentSourceHelper;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.httpclient.HttpRedirectStrategy;
import org.carrot2.util.httpclient.HttpUtils;
import org.carrot2.util.resource.IResource;

@Bindable
public abstract class RemoteXmlSimpleSearchEngineBase
extends SimpleSearchEngine {
    private final XmlDocumentSourceHelper xmlDocumentSourceHelper = new XmlDocumentSourceHelper();
    @Input
    @Processing
    @Attribute
    @Label(value="HTTP redirect strategy")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Service")
    @Internal
    public HttpRedirectStrategy redirectStrategy = HttpRedirectStrategy.NO_REDIRECTS;
    private Templates toCarrot2Xslt;

    public void init(IControllerContext iControllerContext) {
        super.init(iControllerContext);
        this.toCarrot2Xslt = this.xmlDocumentSourceHelper.loadXslt(this.getXsltResource());
    }

    public void beforeProcessing() throws ProcessingException {
        super.beforeProcessing();
        if (this.toCarrot2Xslt == null) {
            throw new ProcessingException("XSLT stylesheet must not be null");
        }
    }

    protected SearchEngineResponse fetchSearchResponse() throws Exception {
        String string = this.buildServiceUrl();
        SearchEngineResponse searchEngineResponse = new SearchEngineResponse();
        ProcessingResult processingResult = this.loadProcessingResult(string, this.toCarrot2Xslt, this.getXsltParameters(), searchEngineResponse.metadata, this.getUser(), this.getPassword(), this.redirectStrategy);
        List list = processingResult.getDocuments();
        if (list != null) {
            searchEngineResponse.results.addAll(list);
            Map map = processingResult.getAttributes();
            searchEngineResponse.metadata.put("resultsTotal", map.containsKey("results-total") ? map.get("results-total") : Long.valueOf(list.size()));
        } else {
            searchEngineResponse.metadata.put("resultsTotal", 0L);
        }
        this.afterFetch(searchEngineResponse);
        this.afterFetch(searchEngineResponse, processingResult);
        return searchEngineResponse;
    }

    protected void afterFetch(SearchEngineResponse searchEngineResponse, ProcessingResult processingResult) {
    }

    protected abstract IResource getXsltResource();

    protected Map<String, String> getXsltParameters() {
        return null;
    }

    protected abstract String buildServiceUrl();

    protected String getUser() {
        return HttpAuthHub.getUser();
    }

    protected String getPassword() {
        char[] cArray = HttpAuthHub.getPassword();
        return cArray == null ? null : new String(cArray);
    }

    protected ProcessingResult loadProcessingResult(String string, Templates templates, Map<String, String> map, Map<String, Object> map2, String string2, String string3, HttpRedirectStrategy httpRedirectStrategy) throws Exception {
        HttpUtils.Response response = HttpUtils.doGET((String)string, null, null, (String)string2, (String)string3, (int)(this.xmlDocumentSourceHelper.timeout * 1000), (RedirectStrategy)httpRedirectStrategy.value());
        InputStream inputStream = response.getPayloadAsStream();
        int n = response.status;
        if (n == 200) {
            map2.put("compression", response.compression);
            return this.xmlDocumentSourceHelper.loadProcessingResult(inputStream, templates, map);
        }
        throw new HttpResponseException(n, response.statusMessage);
    }
}

