/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.xml;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.IDocumentSource;
import org.carrot2.core.ProcessingComponentBase;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.ProcessingResult;
import org.carrot2.core.attribute.CommonAttributes;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.xml.XmlDocumentSourceHelper;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.carrot2.util.attribute.constraint.IntRange;
import org.carrot2.util.attribute.constraint.ResourceNameFilter;
import org.carrot2.util.attribute.constraint.ResourceNameFilters;
import org.carrot2.util.resource.FileResource;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.URLResource;
import org.carrot2.util.resource.URLResourceWithParams;

@Bindable(prefix="XmlDocumentSource", inherit={CommonAttributes.class})
public class XmlDocumentSource
extends ProcessingComponentBase
implements IDocumentSource {
    private static final String XML_DATA = "XML data";
    private static final String XML_TRANSFORMATION = "XML transformation";
    @Input
    @Init
    @Processing
    @Attribute
    @Required
    @Internal(configuration=true)
    @ImplementingClasses(classes={FileResource.class, URLResourceWithParams.class, URLResource.class}, strict=false)
    @ResourceNameFilters(filters={@ResourceNameFilter(pattern="*.xml;*.XML", description="XML files"), @ResourceNameFilter(pattern="*.*", description="All files")})
    @Label(value="XML resource")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="XML data")
    public IResource xml;
    @Input
    @Init
    @Processing
    @Attribute
    @Internal(configuration=true)
    @ImplementingClasses(classes={FileResource.class, URLResourceWithParams.class, URLResource.class}, strict=false)
    @ResourceNameFilters(filters={@ResourceNameFilter(pattern="*.xsl;*.xslt;*.XSL;*.XSLT", description="XML stylesheets"), @ResourceNameFilter(pattern="*.*", description="All files")})
    @Label(value="XSLT stylesheet")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="XML transformation")
    public IResource xslt;
    @Input
    @Init
    @Processing
    @Attribute
    @Internal(configuration=true)
    @Label(value="XML parameters")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="XML data")
    public Map<String, String> xmlParameters = ImmutableMap.of();
    @Input
    @Init
    @Processing
    @Attribute
    @Internal(configuration=true)
    @Label(value="XSLT parameters")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="XML transformation")
    public Map<String, String> xsltParameters = ImmutableMap.of();
    @Input
    @Output
    @Processing
    @Attribute(key="query", inherit=true)
    public String query;
    @Input
    @Processing
    @Attribute(key="results", inherit=true)
    @IntRange(min=1)
    public int results = 100;
    @Input
    @Init
    @Processing
    @Attribute
    @Label(value="Read clusters from input")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="XML transformation")
    public boolean readClusters = false;
    @Input
    @Processing
    @Attribute
    @Label(value="Read all documents")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Search query")
    public boolean readAll = true;
    @Output
    @Processing
    @Attribute(key="processing-result.title", inherit=true)
    public String title;
    @Processing
    @Output
    @Attribute(key="documents", inherit=true)
    public List<Document> documents;
    @Processing
    @Input
    @Output
    @Internal
    @Attribute(key="clusters", inherit=true)
    public List<Cluster> clusters;
    private IResource initXslt;
    private Templates instanceLevelXslt;
    private final XmlDocumentSourceHelper xmlDocumentSourceHelper = new XmlDocumentSourceHelper();

    public void init(IControllerContext iControllerContext) {
        super.init(iControllerContext);
        if (this.xslt != null) {
            this.initXslt = this.xslt;
            this.instanceLevelXslt = this.xmlDocumentSourceHelper.loadXslt(this.xslt);
        }
    }

    public void process() throws ProcessingException {
        try {
            this.title = null;
            ProcessingResult processingResult = this.xmlDocumentSourceHelper.loadProcessingResult(this.openResource(this.xml), this.resolveStylesheet(), this.xsltParameters);
            this.query = (String)processingResult.getAttributes().get("query");
            this.documents = processingResult.getDocuments();
            if (this.readClusters) {
                this.clusters = processingResult.getClusters();
            }
            if (!StringUtils.isEmpty((String)this.query)) {
                this.title = null;
            }
            if (this.documents == null) {
                this.documents = Lists.newArrayList();
            }
            if (!this.readAll && this.documents.size() > this.results) {
                this.documents = this.documents.subList(0, this.results);
            }
        }
        catch (Exception exception) {
            throw new ProcessingException("Could not process query: " + exception.getMessage(), (Throwable)exception);
        }
    }

    private Templates resolveStylesheet() {
        Templates templates = this.instanceLevelXslt;
        if (this.xslt != null) {
            if (!ObjectUtils.equals((Object)this.xslt, (Object)this.initXslt)) {
                templates = this.xmlDocumentSourceHelper.loadXslt(this.xslt);
            }
        } else {
            templates = null;
        }
        return templates;
    }

    private InputStream openResource(IResource iResource) throws IOException {
        this.title = iResource.toString();
        if (iResource instanceof URLResourceWithParams) {
            if (StringUtils.isNotBlank((String)this.query)) {
                this.title = this.query;
            }
            HashMap hashMap = Maps.newHashMap();
            hashMap.put("query", this.query != null ? this.query : "");
            hashMap.put("results", this.results != -1 ? Integer.valueOf(this.results) : "");
            hashMap.putAll(this.xmlParameters);
            return ((URLResourceWithParams)iResource).open((Map)hashMap);
        }
        if (iResource instanceof FileResource) {
            this.title = ((FileResource)iResource).getFile().getName();
        }
        return iResource.open();
    }
}

