/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.carrot2.core.ProcessingResult;
import org.carrot2.core.attribute.Processing;
import org.carrot2.util.CloseableUtils;
import org.carrot2.util.StreamUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.constraint.IntRange;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.xslt.NopURIResolver;
import org.carrot2.util.xslt.TemplatesPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Bindable(prefix="XmlDocumentSourceHelper")
public class XmlDocumentSourceHelper {
    @Input
    @Processing
    @Attribute
    @IntRange(min=0, max=300)
    @Label(value="Data transfer timeout")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Service")
    public int timeout = 8;
    private final TemplatesPool pool;
    private static final URIResolver uriResolver = new NopURIResolver();
    private static final Logger log = LoggerFactory.getLogger(XmlDocumentSourceHelper.class);

    public XmlDocumentSourceHelper() {
        try {
            this.pool = new TemplatesPool(false);
            this.pool.tFactory.setURIResolver(uriResolver);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public ProcessingResult loadProcessingResult(InputStream inputStream, Templates templates, Map<String, String> map) throws Exception {
        ProcessingResult processingResult;
        InputStream inputStream2 = null;
        try {
            inputStream2 = this.getCarrot2XmlStream(inputStream, templates, map);
            processingResult = ProcessingResult.deserialize((InputStream)inputStream2);
        }
        catch (Throwable throwable) {
            CloseableUtils.close((Closeable[])new Closeable[]{inputStream2, inputStream});
            throw throwable;
        }
        CloseableUtils.close((Closeable[])new Closeable[]{inputStream2, inputStream});
        return processingResult;
    }

    private InputStream getCarrot2XmlStream(InputStream inputStream, Templates templates, Map<String, String> map) throws TransformerConfigurationException, IOException, TransformerException {
        InputStream inputStream2;
        block10: {
            if (templates != null) {
                byte[] byArray = null;
                try {
                    try {
                        Transformer transformer = this.pool.newTransformer(templates);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        if (map != null) {
                            for (Map.Entry<String, String> entry : map.entrySet()) {
                                transformer.setParameter(entry.getKey(), entry.getValue());
                            }
                        }
                        if (log.isDebugEnabled()) {
                            byArray = StreamUtils.readFullyAndClose((InputStream)inputStream);
                            inputStream = new ByteArrayInputStream(byArray);
                        }
                        transformer.transform(new StreamSource(inputStream), new StreamResult(byteArrayOutputStream));
                        inputStream2 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                        break block10;
                    }
                    catch (TransformerException transformerException) {
                        if (byArray != null) {
                            log.debug("Transformer input: " + new String(byArray, "UTF-8"));
                        }
                        throw transformerException;
                    }
                }
                finally {
                    CloseableUtils.close((Closeable)inputStream);
                }
            }
            inputStream2 = inputStream;
        }
        return inputStream2;
    }

    public Templates loadXslt(IResource iResource) {
        InputStream inputStream = null;
        try {
            inputStream = iResource.open();
            Templates templates = this.pool.compileTemplate(inputStream);
            return templates;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
        finally {
            CloseableUtils.close((Closeable)inputStream);
        }
    }
}

