/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.clustering;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.attribute.Processing;
import org.carrot2.text.clustering.IMonolingualClusteringAlgorithm;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.attribute.Required;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable(prefix="MultilingualClustering")
public class MultilingualClustering {
    private static final String MULTILINGUAL_CLUSTERING = "Multilingual clustering";
    private static final Logger logger = LoggerFactory.getLogger(MultilingualClustering.class);
    @Input
    @Processing
    @Attribute
    @Required
    @Group(value="Multilingual clustering")
    @Level(value=AttributeLevel.MEDIUM)
    public LanguageAggregationStrategy languageAggregationStrategy = LanguageAggregationStrategy.FLATTEN_MAJOR_LANGUAGE;
    @Input
    @Processing
    @Attribute
    @Required
    @Group(value="Multilingual clustering")
    @Level(value=AttributeLevel.MEDIUM)
    public LanguageCode defaultLanguage = LanguageCode.ENGLISH;
    @Output
    @Processing
    @Attribute
    @Group(value="Multilingual clustering")
    @Level(value=AttributeLevel.MEDIUM)
    public Map<String, Integer> languageCounts;
    @Output
    @Processing
    @Attribute
    @Group(value="Multilingual clustering")
    @Level(value=AttributeLevel.MEDIUM)
    public String majorityLanguage = "";

    public List<Cluster> process(List<Document> list, IMonolingualClusteringAlgorithm iMonolingualClusteringAlgorithm) {
        this.languageCounts = Maps.newHashMap();
        if (list.isEmpty()) {
            return Lists.newArrayList();
        }
        if (LanguageAggregationStrategy.CLUSTER_IN_MAJORITY_LANGUAGE.equals((Object)this.languageAggregationStrategy)) {
            return this.clusterInMajorityLanguage(list, iMonolingualClusteringAlgorithm);
        }
        Map<LanguageCode, Cluster> map = this.clusterByLanguage(list, iMonolingualClusteringAlgorithm);
        ArrayList arrayList = Lists.newArrayList(map.values());
        if (map.size() == 1 || LanguageAggregationStrategy.FLATTEN_ALL.equals((Object)this.languageAggregationStrategy)) {
            ArrayList arrayList2 = Lists.newArrayList();
            for (Cluster cluster : arrayList) {
                List list2 = cluster.getSubclusters();
                for (Cluster cluster2 : list2) {
                    if (cluster2.isOtherTopics()) continue;
                    arrayList2.add(cluster2);
                }
            }
            if (map.size() > 1) {
                Collections.sort(arrayList2, Cluster.BY_REVERSED_SIZE_AND_LABEL_COMPARATOR);
            }
            Cluster.appendOtherTopics(list, (List)arrayList2);
            return arrayList2;
        }
        Collections.sort(arrayList, Collections.reverseOrder(Cluster.BY_SIZE_COMPARATOR));
        if (LanguageAggregationStrategy.FLATTEN_MAJOR_LANGUAGE.equals((Object)this.languageAggregationStrategy)) {
            Iterator iterator = arrayList.iterator();
            Cluster cluster = null;
            try {
                cluster = (Cluster)Iterators.find(iterator, (Predicate)new Predicate<Cluster>(){

                    public boolean apply(Cluster cluster) {
                        return !cluster.getSubclusters().isEmpty();
                    }
                });
            }
            catch (NoSuchElementException noSuchElementException) {}
            if (cluster != null) {
                iterator.remove();
                ArrayList arrayList3 = Lists.newArrayList();
                arrayList3.addAll(cluster.getSubclusters());
                Cluster cluster3 = new Cluster("Other Languages", new Document[0]);
                cluster3.addSubclusters((Iterable)arrayList);
                arrayList3.add(cluster3);
                return arrayList3;
            }
            return arrayList;
        }
        return arrayList;
    }

    private Map<LanguageCode, Cluster> clusterByLanguage(List<Document> list, IMonolingualClusteringAlgorithm iMonolingualClusteringAlgorithm) {
        ImmutableListMultimap immutableListMultimap = Multimaps.index(list, (Function)new Function<Document, String>(){

            public String apply(Document document) {
                LanguageCode languageCode = document.getLanguage();
                return languageCode != null ? languageCode.name() : "";
            }
        });
        HashMap hashMap = Maps.newHashMap();
        for (String string : immutableListMultimap.keySet()) {
            ImmutableList immutableList = immutableListMultimap.get((Object)string);
            LanguageCode languageCode = string.equals("") ? null : LanguageCode.valueOf((String)string);
            Cluster cluster = new Cluster(languageCode != null ? languageCode.toString() : "Unknown Language", new Document[0]);
            this.languageCounts.put(languageCode != null ? languageCode.getIsoCode() : "", immutableList.size());
            LanguageCode languageCode2 = languageCode != null ? languageCode : this.defaultLanguage;
            logger.debug("Performing monolingual clustering in: " + languageCode2);
            List<Cluster> list2 = iMonolingualClusteringAlgorithm.process((List<Document>)immutableList, languageCode2);
            if (list2.size() == 0 || list2.size() == 1 && list2.get(0).isOtherTopics()) {
                cluster.addDocuments((Iterable)immutableList);
            } else {
                cluster.addSubclusters(list2);
            }
            hashMap.put(languageCode, cluster);
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private List<Cluster> clusterInMajorityLanguage(List<Document> list, IMonolingualClusteringAlgorithm iMonolingualClusteringAlgorithm) {
        void var4_8;
        Object object2;
        HashMultiset hashMultiset = HashMultiset.create();
        for (Document languageCode2 : list) {
            hashMultiset.add((Object)languageCode2.getLanguage());
        }
        LanguageCode languageCode = this.defaultLanguage;
        int n = 0;
        for (Object object2 : hashMultiset.entrySet()) {
            if (object2.getElement() != null && object2.getCount() > n) {
                n = object2.getCount();
                LanguageCode languageCode2 = (LanguageCode)object2.getElement();
                this.majorityLanguage = ((LanguageCode)object2.getElement()).getIsoCode();
            }
            this.languageCounts.put(object2.getElement() != null ? ((LanguageCode)object2.getElement()).getIsoCode() : "", object2.getCount());
        }
        logger.debug("Performing clustering in majority language: " + var4_8);
        object2 = iMonolingualClusteringAlgorithm.process(list, (LanguageCode)var4_8);
        Cluster.appendOtherTopics(list, (List)object2);
        return object2;
    }

    public static enum LanguageAggregationStrategy {
        FLATTEN_ALL("Flatten clusters from all languages"),
        FLATTEN_MAJOR_LANGUAGE("Flatten clusters from the majority language"),
        FLATTEN_NONE("Dedicated parent cluster for each language"),
        CLUSTER_IN_MAJORITY_LANGUAGE("Cluster all documents assuming the language of the majority");

        private String label;

        private LanguageAggregationStrategy(String string2) {
            this.label = string2;
        }

        public String toString() {
            return this.label;
        }
    }
}

