/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic;

import com.carrotsearch.hppc.ObjectHashSet;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.carrot2.text.linguistic.ILexicalData;
import org.carrot2.text.util.MutableCharArray;

final class DefaultLexicalData
implements ILexicalData {
    private final ObjectHashSet<MutableCharArray> stopwords;
    private final Pattern stoplabelPattern;

    public DefaultLexicalData(ObjectHashSet<MutableCharArray> objectHashSet, ArrayList<Pattern> arrayList) {
        this.stopwords = objectHashSet;
        this.stoplabelPattern = DefaultLexicalData.union(arrayList);
    }

    @Override
    public boolean isCommonWord(MutableCharArray mutableCharArray) {
        return this.stopwords.contains((Object)mutableCharArray);
    }

    @Override
    public boolean isStopLabel(CharSequence charSequence) {
        if (this.stoplabelPattern == null) {
            return false;
        }
        return this.stoplabelPattern.matcher(charSequence).matches();
    }

    private static Pattern union(ArrayList<Pattern> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        if (arrayList.size() > 0) {
            stringBuilder.append("(");
            int n = 0;
            while (n < arrayList.size()) {
                if (n > 0) {
                    stringBuilder.append(")|(");
                }
                stringBuilder.append(arrayList.get(n).toString());
                ++n;
            }
            stringBuilder.append(")");
            return Pattern.compile(stringBuilder.toString());
        }
        return null;
    }
}

