/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic;

import com.carrotsearch.hppc.ObjectHashSet;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.text.linguistic.DefaultLexicalData;
import org.carrot2.text.linguistic.ILexicalData;
import org.carrot2.text.linguistic.ILexicalDataFactory;
import org.carrot2.text.linguistic.LexicalDataLoader;
import org.carrot2.text.util.MutableCharArray;
import org.carrot2.util.CharArrayUtils;
import org.carrot2.util.annotations.AspectModified;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.ResourceCache;
import org.carrot2.util.resource.ResourceLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable(inherit={LexicalDataLoader.class})
public class DefaultLexicalDataFactory
implements ILexicalDataFactory {
    static final Logger logger = LoggerFactory.getLogger(DefaultLexicalDataFactory.class);
    private static final Function<ResourceLookup, HashMap<LanguageCode, ILexicalData>> resourceLoader = new Function<ResourceLookup, HashMap<LanguageCode, ILexicalData>>(){

        public HashMap<LanguageCode, ILexicalData> apply(ResourceLookup resourceLookup) {
            return DefaultLexicalDataFactory.reloadResources(resourceLookup);
        }

        public boolean equals(Object object) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    };
    private static final ResourceCache<HashMap<LanguageCode, ILexicalData>> cache = new ResourceCache(resourceLoader);
    @Processing
    @Input
    @Attribute(key="reload-resources", inherit=true)
    public boolean reloadResources = false;
    @Init
    @Processing
    @Input
    @Attribute(key="merge-resources")
    @Label(value="Merge lexical resources")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Preprocessing")
    public boolean mergeResources = true;
    @Init
    @Processing
    @Input
    @Internal
    @Attribute(key="resource-lookup", inherit=true)
    @ImplementingClasses(classes={}, strict=false)
    @AspectModified(value="Substituted with an assembly lookup in .NET release")
    public ResourceLookup resourceLookup = new ResourceLookup(new ResourceLookup.Location[]{ResourceLookup.Location.CONTEXT_CLASS_LOADER});

    @Override
    public ILexicalData getLexicalData(LanguageCode languageCode) {
        if (this.mergeResources) {
            languageCode = null;
        }
        ILexicalData iLexicalData = (ILexicalData)((HashMap)cache.get(this.resourceLookup, this.reloadResources)).get(languageCode);
        this.reloadResources = false;
        return iLexicalData;
    }

    private static HashMap<LanguageCode, ILexicalData> reloadResources(ResourceLookup resourceLookup) {
        ObjectHashSet objectHashSet = new ObjectHashSet();
        ArrayList arrayList = Lists.newArrayList();
        HashMap hashMap = Maps.newHashMap();
        LanguageCode[] languageCodeArray = LanguageCode.values();
        int n = languageCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageCode languageCode = languageCodeArray[n2];
            String string = languageCode.getIsoCode();
            ObjectHashSet<MutableCharArray> objectHashSet2 = DefaultLexicalDataFactory.toLower(DefaultLexicalDataFactory.load(resourceLookup, "stopwords." + string));
            ArrayList<Pattern> arrayList2 = DefaultLexicalDataFactory.compile(DefaultLexicalDataFactory.load(resourceLookup, "stoplabels." + string));
            objectHashSet.addAll(objectHashSet2);
            arrayList.addAll(arrayList2);
            hashMap.put(languageCode, new DefaultLexicalData(objectHashSet2, arrayList2));
            ++n2;
        }
        hashMap.put(null, new DefaultLexicalData((ObjectHashSet<MutableCharArray>)objectHashSet, arrayList));
        return hashMap;
    }

    private static ObjectHashSet<MutableCharArray> toLower(Set<String> set) {
        ObjectHashSet objectHashSet = new ObjectHashSet(set.size());
        for (String string : set) {
            char[] cArray = string.toCharArray();
            CharArrayUtils.toLowerCaseInPlace((char[])cArray);
            objectHashSet.add((Object)new MutableCharArray(cArray));
        }
        return objectHashSet;
    }

    private static ArrayList<Pattern> compile(HashSet<String> hashSet) {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>(hashSet.size());
        for (String string : hashSet) {
            try {
                arrayList.add(Pattern.compile(string));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                logger.warn("Ignoring invalid regular expression: " + string);
            }
        }
        return arrayList;
    }

    private static HashSet<String> load(ResourceLookup resourceLookup, String string) {
        IResource iResource = resourceLookup.getFirst(string);
        if (iResource == null) {
            throw new RuntimeException("No resource named " + string + " in resource lookup locations: " + Arrays.toString(resourceLookup.getLocators()));
        }
        try {
            return DefaultLexicalDataFactory.load(iResource);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Resource named " + string + " failed to load from: " + iResource.toString());
        }
    }

    public static HashSet<String> load(IResource iResource) throws IOException {
        HashSet hashSet = Sets.newHashSet();
        InputStream inputStream = iResource.open();
        if (inputStream == null) {
            throw new IOException("Resource returned null stream: " + iResource);
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("#") || string.length() == 0) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }
}

