/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.text.linguistic.LexicalDataLoaderDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;
import org.carrot2.util.resource.ResourceLookup;

public final class DefaultLexicalDataFactoryDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.text.linguistic.DefaultLexicalDataFactory";
    public final String prefix = "";
    public final String title = "The default management of lexical resources";
    public final String label = "";
    public final String description = "Resources are read from disk, cached and shared between <b>all</b> threads using this class. Additional attributes control resource reloading and merging: <code>org.carrot2.text.linguistic.DefaultLexicalDataFactory.resourceLookup</code>, <code>org.carrot2.text.linguistic.DefaultLexicalDataFactory.reloadResources</code>, <code>org.carrot2.text.linguistic.DefaultLexicalDataFactory.mergeResources</code>.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(DefaultLexicalDataFactoryDescriptor.attributes.mergeResources);
        hashSet.add(DefaultLexicalDataFactoryDescriptor.attributes.reloadResources);
        hashSet.add(DefaultLexicalDataFactoryDescriptor.attributes.resourceLookup);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(DefaultLexicalDataFactoryDescriptor.attributes.mergeResources);
        hashSet2.add(DefaultLexicalDataFactoryDescriptor.attributes.reloadResources);
        hashSet2.add(DefaultLexicalDataFactoryDescriptor.attributes.resourceLookup);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "";
    }

    public String getTitle() {
        return "The default management of lexical resources";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "Resources are read from disk, cached and shared between <b>all</b> threads using this class. Additional attributes control resource reloading and merging: <code>org.carrot2.text.linguistic.DefaultLexicalDataFactory.resourceLookup</code>, <code>org.carrot2.text.linguistic.DefaultLexicalDataFactory.reloadResources</code>, <code>org.carrot2.text.linguistic.DefaultLexicalDataFactory.mergeResources</code>.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder mergeResources(boolean bl) {
            this.map.put("merge-resources", bl);
            return this;
        }

        public AttributeBuilder mergeResources(IObjectFactory<? extends Boolean> iObjectFactory) {
            this.map.put("merge-resources", iObjectFactory);
            return this;
        }

        public AttributeBuilder reloadResources(boolean bl) {
            this.map.put("reload-resources", bl);
            return this;
        }

        public AttributeBuilder reloadResources(IObjectFactory<? extends Boolean> iObjectFactory) {
            this.map.put("reload-resources", iObjectFactory);
            return this;
        }

        public AttributeBuilder resourceLookup(ResourceLookup resourceLookup) {
            this.map.put("resource-lookup", resourceLookup);
            return this;
        }

        public AttributeBuilder resourceLookup(Class<?> clazz) {
            this.map.put("resource-lookup", clazz);
            return this;
        }

        public AttributeBuilder resourceLookup(IObjectFactory<? extends ResourceLookup> iObjectFactory) {
            this.map.put("resource-lookup", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo mergeResources = new AttributeInfo("merge-resources", "org.carrot2.text.linguistic.DefaultLexicalDataFactory", "mergeResources", "Merges stop words and stop labels from all known languages. If set to\n<code>false</code>, only stop words and stop labels of the active language will be\nused. If set to <code>true</code>, stop words from all {@link org.carrot2.core.LanguageCode}s will\nbe used together and stop labels from all languages will be used together, no\nmatter the active language. Lexical resource merging is useful when clustering data\nin a mix of different languages and should increase clustering quality in such\nsettings.", "Merge lexical resources", "Merges stop words and stop labels from all known languages", "If set to <code>false</code>, only stop words and stop labels of the active language will be used. If set to <code>true</code>, stop words from all <code>org.carrot2.core.LanguageCode</code>s will be used together and stop labels from all languages will be used together, no matter the active language. Lexical resource merging is useful when clustering data in a mix of different languages and should increase clustering quality in such settings.", "Preprocessing", AttributeLevel.MEDIUM, null);
        public final AttributeInfo reloadResources;
        public final AttributeInfo resourceLookup;

        private Attributes() {
            this.reloadResources = new AttributeInfo("reload-resources", "org.carrot2.text.linguistic.DefaultLexicalDataFactory", "reloadResources", null, null, null, null, null, null, LexicalDataLoaderDescriptor.attributes.reloadResources);
            this.resourceLookup = new AttributeInfo("resource-lookup", "org.carrot2.text.linguistic.DefaultLexicalDataFactory", "resourceLookup", null, null, null, null, null, null, LexicalDataLoaderDescriptor.attributes.resourceLookup);
        }
    }

    public static class Keys {
        public static final String MERGE_RESOURCES = "merge-resources";
        public static final String RELOAD_RESOURCES = "reload-resources";
        public static final String RESOURCE_LOOKUP = "resource-lookup";

        protected Keys() {
        }
    }
}

