/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import org.carrot2.core.LanguageCode;
import org.carrot2.text.linguistic.IStemmer;
import org.carrot2.text.linguistic.IStemmerFactory;
import org.carrot2.text.linguistic.IdentityStemmer;
import org.carrot2.text.linguistic.lucene.ArabicStemmerAdapter;
import org.carrot2.text.linguistic.lucene.HindiStemmerAdapter;
import org.carrot2.text.linguistic.lucene.SnowballStemmerFactory;
import org.carrot2.text.linguistic.morfologik.MorfologikStemmerAdapter;
import org.carrot2.util.annotations.ThreadSafe;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.factory.FallbackFactory;
import org.carrot2.util.factory.IFactory;
import org.carrot2.util.factory.NewClassInstanceFactory;
import org.carrot2.util.factory.SingletonFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable
@ThreadSafe
public class DefaultStemmerFactory
implements IStemmerFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStemmerFactory.class);
    private static final EnumMap<LanguageCode, IFactory<IStemmer>> stemmerFactories;
    private static final Predicate<IStemmer> stemmerVerifier;

    static {
        stemmerVerifier = new Predicate<IStemmer>(){

            public boolean apply(IStemmer iStemmer) {
                iStemmer.stem("verification");
                return true;
            }
        };
        stemmerFactories = DefaultStemmerFactory.createDefaultStemmers();
    }

    @Override
    public IStemmer getStemmer(LanguageCode languageCode) {
        return (IStemmer)stemmerFactories.get(languageCode).createInstance();
    }

    private static EnumMap<LanguageCode, IFactory<IStemmer>> createDefaultStemmers() {
        SingletonFactory singletonFactory = new SingletonFactory((Object)new IdentityStemmer());
        EnumMap enumMap = Maps.newEnumMap(LanguageCode.class);
        enumMap.put(LanguageCode.POLISH, new NewClassInstanceFactory(MorfologikStemmerAdapter.class));
        enumMap.put(LanguageCode.ARABIC, new NewClassInstanceFactory(ArabicStemmerAdapter.class));
        enumMap.put(LanguageCode.DANISH, new SnowballStemmerFactory("org.tartarus.snowball.ext.DanishStemmer"));
        enumMap.put(LanguageCode.DUTCH, new SnowballStemmerFactory("org.tartarus.snowball.ext.DutchStemmer"));
        enumMap.put(LanguageCode.ENGLISH, new SnowballStemmerFactory("org.tartarus.snowball.ext.EnglishStemmer"));
        enumMap.put(LanguageCode.FINNISH, new SnowballStemmerFactory("org.tartarus.snowball.ext.FinnishStemmer"));
        enumMap.put(LanguageCode.FRENCH, new SnowballStemmerFactory("org.tartarus.snowball.ext.FrenchStemmer"));
        enumMap.put(LanguageCode.GERMAN, new SnowballStemmerFactory("org.tartarus.snowball.ext.GermanStemmer"));
        enumMap.put(LanguageCode.HUNGARIAN, new SnowballStemmerFactory("org.tartarus.snowball.ext.HungarianStemmer"));
        enumMap.put(LanguageCode.ITALIAN, new SnowballStemmerFactory("org.tartarus.snowball.ext.ItalianStemmer"));
        enumMap.put(LanguageCode.NORWEGIAN, new SnowballStemmerFactory("org.tartarus.snowball.ext.NorwegianStemmer"));
        enumMap.put(LanguageCode.PORTUGUESE, new SnowballStemmerFactory("org.tartarus.snowball.ext.PortugueseStemmer"));
        enumMap.put(LanguageCode.ROMANIAN, new SnowballStemmerFactory("org.tartarus.snowball.ext.RomanianStemmer"));
        enumMap.put(LanguageCode.RUSSIAN, new SnowballStemmerFactory("org.tartarus.snowball.ext.RussianStemmer"));
        enumMap.put(LanguageCode.SPANISH, new SnowballStemmerFactory("org.tartarus.snowball.ext.SpanishStemmer"));
        enumMap.put(LanguageCode.SWEDISH, new SnowballStemmerFactory("org.tartarus.snowball.ext.SwedishStemmer"));
        enumMap.put(LanguageCode.TURKISH, new SnowballStemmerFactory("org.tartarus.snowball.ext.TurkishStemmer"));
        enumMap.put(LanguageCode.CHINESE_SIMPLIFIED, singletonFactory);
        enumMap.put(LanguageCode.HINDI, new NewClassInstanceFactory(HindiStemmerAdapter.class));
        LanguageCode[] languageCodeArray = LanguageCode.values();
        int n = languageCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageCode languageCode = languageCodeArray[n2];
            if (enumMap.containsKey(languageCode)) {
                IFactory iFactory = (IFactory)enumMap.get(languageCode);
                if (iFactory != singletonFactory) {
                    iFactory = new FallbackFactory(iFactory, (IFactory)singletonFactory, stemmerVerifier, logger, "Stemmer for " + languageCode.toString() + " (" + languageCode.getIsoCode() + ") is not available." + " This may degrade clustering quality of " + languageCode.toString() + " content. Cause: {}");
                    enumMap.put(languageCode, iFactory);
                }
            } else {
                enumMap.put(languageCode, singletonFactory);
            }
            ++n2;
        }
        return enumMap;
    }
}

