/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringReader;
import java.util.EnumMap;
import org.carrot2.core.LanguageCode;
import org.carrot2.text.analysis.ExtendedWhitespaceTokenizer;
import org.carrot2.text.analysis.ITokenizer;
import org.carrot2.text.linguistic.ITokenizerFactory;
import org.carrot2.text.linguistic.JapaneseUnsupportedStub;
import org.carrot2.text.linguistic.lucene.ChineseTokenizerAdapter;
import org.carrot2.text.linguistic.lucene.ThaiTokenizerAdapter;
import org.carrot2.util.annotations.ThreadSafe;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.factory.FallbackFactory;
import org.carrot2.util.factory.IFactory;
import org.carrot2.util.factory.NewClassInstanceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable
@ThreadSafe
public class DefaultTokenizerFactory
implements ITokenizerFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTokenizerFactory.class);
    private static final EnumMap<LanguageCode, IFactory<ITokenizer>> tokenizerFactories;
    private static final Predicate<ITokenizer> tokenizerVerifier;

    static {
        tokenizerVerifier = new Predicate<ITokenizer>(){

            public boolean apply(ITokenizer iTokenizer) {
                try {
                    iTokenizer.reset(new StringReader("verify"));
                    iTokenizer.nextToken();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                return true;
            }
        };
        tokenizerFactories = DefaultTokenizerFactory.createDefaultTokenizers();
    }

    @Override
    public ITokenizer getTokenizer(LanguageCode languageCode) {
        return (ITokenizer)tokenizerFactories.get(languageCode).createInstance();
    }

    private static EnumMap<LanguageCode, IFactory<ITokenizer>> createDefaultTokenizers() {
        LanguageCode languageCode;
        EnumMap enumMap = Maps.newEnumMap(LanguageCode.class);
        NewClassInstanceFactory newClassInstanceFactory = new NewClassInstanceFactory(ExtendedWhitespaceTokenizer.class);
        LanguageCode[] languageCodeArray = LanguageCode.values();
        int n = languageCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            languageCode = languageCodeArray[n2];
            enumMap.put(languageCode, newClassInstanceFactory);
            ++n2;
        }
        enumMap.put(LanguageCode.CHINESE_SIMPLIFIED, new NewClassInstanceFactory(ChineseTokenizerAdapter.class));
        enumMap.put(LanguageCode.THAI, new NewClassInstanceFactory(ThaiTokenizerAdapter.class));
        enumMap.put(LanguageCode.JAPANESE, new JapaneseUnsupportedStub());
        languageCodeArray = LanguageCode.values();
        n = languageCodeArray.length;
        n2 = 0;
        while (n2 < n) {
            languageCode = languageCodeArray[n2];
            if (enumMap.containsKey(languageCode)) {
                IFactory iFactory = (IFactory)enumMap.get(languageCode);
                if (iFactory != newClassInstanceFactory) {
                    enumMap.put(languageCode, new FallbackFactory(iFactory, (IFactory)newClassInstanceFactory, tokenizerVerifier, logger, "Tokenizer for " + languageCode.toString() + " (" + languageCode.getIsoCode() + ") is not available." + " This may degrade clustering quality of " + languageCode.toString() + " content. Cause: {}"));
                }
            } else {
                enumMap.put(languageCode, newClassInstanceFactory);
            }
            ++n2;
        }
        return enumMap;
    }
}

