/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic;

import org.carrot2.core.LanguageCode;
import org.carrot2.text.analysis.ITokenizer;
import org.carrot2.text.linguistic.ILexicalData;
import org.carrot2.text.linguistic.ILexicalDataFactory;
import org.carrot2.text.linguistic.IStemmer;
import org.carrot2.text.linguistic.IStemmerFactory;
import org.carrot2.text.linguistic.ITokenizerFactory;
import org.carrot2.util.factory.CachedInstanceFactoryDecorator;
import org.carrot2.util.factory.IFactory;

public final class LanguageModel {
    private final LanguageCode languageCode;
    private final IFactory<IStemmer> stemmerFactory;
    private final IFactory<ITokenizer> tokenizerFactory;
    private final IFactory<ILexicalData> lexicalDataFactory;

    LanguageModel(LanguageCode languageCode, IFactory<IStemmer> iFactory, IFactory<ITokenizer> iFactory2, IFactory<ILexicalData> iFactory3) {
        this.languageCode = languageCode;
        this.stemmerFactory = new CachedInstanceFactoryDecorator(iFactory);
        this.tokenizerFactory = new CachedInstanceFactoryDecorator(iFactory2);
        this.lexicalDataFactory = new CachedInstanceFactoryDecorator(iFactory3);
    }

    public static LanguageModel create(final LanguageCode languageCode, final IStemmerFactory iStemmerFactory, final ITokenizerFactory iTokenizerFactory, final ILexicalDataFactory iLexicalDataFactory) {
        return new LanguageModel(languageCode, new IFactory<IStemmer>(){

            public IStemmer createInstance() {
                return iStemmerFactory.getStemmer(languageCode);
            }
        }, new IFactory<ITokenizer>(){

            public ITokenizer createInstance() {
                return iTokenizerFactory.getTokenizer(languageCode);
            }
        }, new IFactory<ILexicalData>(){

            public ILexicalData createInstance() {
                return iLexicalDataFactory.getLexicalData(languageCode);
            }
        });
    }

    public LanguageCode getLanguageCode() {
        return this.languageCode;
    }

    public ILexicalData getLexicalData() {
        return (ILexicalData)this.lexicalDataFactory.createInstance();
    }

    public IStemmer getStemmer() {
        return (IStemmer)this.stemmerFactory.createInstance();
    }

    public ITokenizer getTokenizer() {
        return (ITokenizer)this.tokenizerFactory.createInstance();
    }
}

