/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;
import org.carrot2.util.resource.ResourceLookup;

public final class LexicalDataLoaderDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.text.linguistic.LexicalDataLoader";
    public final String prefix = "";
    public final String title = "Common attributes related to loading and caching of lexical resources";
    public final String label = "";
    public final String description = "";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(LexicalDataLoaderDescriptor.attributes.reloadResources);
        hashSet.add(LexicalDataLoaderDescriptor.attributes.resourceLookup);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(LexicalDataLoaderDescriptor.attributes.reloadResources);
        hashSet2.add(LexicalDataLoaderDescriptor.attributes.resourceLookup);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "";
    }

    public String getTitle() {
        return "Common attributes related to loading and caching of lexical resources";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder reloadResources(boolean bl) {
            this.map.put("reload-resources", bl);
            return this;
        }

        public AttributeBuilder reloadResources(IObjectFactory<? extends Boolean> iObjectFactory) {
            this.map.put("reload-resources", iObjectFactory);
            return this;
        }

        public AttributeBuilder resourceLookup(ResourceLookup resourceLookup) {
            this.map.put("resource-lookup", resourceLookup);
            return this;
        }

        public AttributeBuilder resourceLookup(Class<?> clazz) {
            this.map.put("resource-lookup", clazz);
            return this;
        }

        public AttributeBuilder resourceLookup(IObjectFactory<? extends ResourceLookup> iObjectFactory) {
            this.map.put("resource-lookup", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo reloadResources = new AttributeInfo("reload-resources", "org.carrot2.text.linguistic.LexicalDataLoader", "reloadResources", "Reloads cached stop words and stop labels on every processing request. For best\nperformance, lexical resource reloading should be disabled in production.\n\n<p>This flag is reset to <code>false</code> after successful resource reload to prevent\nmultiple resource reloads during the same processing cycle.</p>", "Reload lexical resources", "Reloads cached stop words and stop labels on every processing request", "For best performance, lexical resource reloading should be disabled in production. <p>This flag is reset to <code>false</code> after successful resource reload to prevent multiple resource reloads during the same processing cycle.</p>", "Preprocessing", AttributeLevel.MEDIUM, null);
        public final AttributeInfo resourceLookup = new AttributeInfo("resource-lookup", "org.carrot2.text.linguistic.LexicalDataLoader", "resourceLookup", "Lexical resource lookup facade. By default, resources are sought in the current\nthread's context class loader. An override of this attribute is possible both at\nthe initialization time and at processing time.", "Resource lookup facade", "Lexical resource lookup facade", "By default, resources are sought in the current thread's context class loader. An override of this attribute is possible both at the initialization time and at processing time.", "Preprocessing", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String RELOAD_RESOURCES = "reload-resources";
        public static final String RESOURCE_LOOKUP = "resource-lookup";

        protected Keys() {
        }
    }
}

