/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic.lucene;

import java.util.Arrays;
import org.apache.lucene.analysis.ar.ArabicNormalizer;
import org.apache.lucene.analysis.ar.ArabicStemmer;
import org.carrot2.text.linguistic.IStemmer;
import org.carrot2.text.util.MutableCharArray;

public class ArabicStemmerAdapter
implements IStemmer {
    private final ArabicStemmer delegate;
    private final ArabicNormalizer normalizer;
    private char[] buffer = new char[0];

    public ArabicStemmerAdapter() {
        this.delegate = new ArabicStemmer();
        this.normalizer = new ArabicNormalizer();
    }

    @Override
    public CharSequence stem(CharSequence charSequence) {
        if (charSequence.length() > this.buffer.length) {
            this.buffer = new char[charSequence.length()];
        }
        int n = 0;
        while (n < charSequence.length()) {
            this.buffer[n] = charSequence.charAt(n);
            ++n;
        }
        n = this.normalizer.normalize(this.buffer, charSequence.length());
        if ((n = this.delegate.stem(this.buffer, n)) != charSequence.length() || !this.equals(this.buffer, n, charSequence)) {
            return new MutableCharArray(Arrays.copyOf(this.buffer, n));
        }
        return null;
    }

    private boolean equals(char[] cArray, int n, CharSequence charSequence) {
        assert (n == charSequence.length());
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] != charSequence.charAt(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

