/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic.lucene;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cn.smart.HMMChineseTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.carrot2.text.analysis.ITokenizer;
import org.carrot2.text.util.MutableCharArray;
import org.carrot2.util.ExceptionUtils;

public final class ChineseTokenizerAdapter
implements ITokenizer {
    private static final Pattern numeric = Pattern.compile("[\\-+'$]?\\d+([:\\-/,.]?\\d+)*[%$]?");
    private Tokenizer sentenceTokenizer;
    private CharTermAttribute term = null;
    private final MutableCharArray tempCharSequence = new MutableCharArray(new char[0]);

    public ChineseTokenizerAdapter() {
        this.sentenceTokenizer = new HMMChineseTokenizer();
    }

    @Override
    public short nextToken() throws IOException {
        boolean bl = this.sentenceTokenizer.incrementToken();
        if (bl) {
            short s = 0;
            char[] cArray = this.term.buffer();
            int n = this.term.length();
            this.tempCharSequence.reset(cArray, 0, n);
            s = n == 1 && cArray[0] == ',' ? (short)3 : (numeric.matcher(this.tempCharSequence).matches() ? (short)2 : 1);
            return s;
        }
        return -1;
    }

    @Override
    public void setTermBuffer(MutableCharArray mutableCharArray) {
        mutableCharArray.reset(this.term.buffer(), 0, this.term.length());
    }

    @Override
    public void reset(Reader reader) throws IOException {
        try {
            if (this.sentenceTokenizer != null) {
                this.sentenceTokenizer.end();
                this.sentenceTokenizer.close();
            }
            this.sentenceTokenizer.setReader(reader);
            this.term = (CharTermAttribute)this.sentenceTokenizer.addAttribute(CharTermAttribute.class);
            this.sentenceTokenizer.reset();
        }
        catch (Exception exception) {
            throw ExceptionUtils.wrapAsRuntimeException((Throwable)exception);
        }
    }
}

