/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic.lucene;

import java.util.Arrays;
import org.carrot2.text.linguistic.IStemmer;
import org.carrot2.text.linguistic.lucene.HindiNormalizer;
import org.carrot2.text.linguistic.lucene.HindiStemmer;
import org.carrot2.text.linguistic.lucene.IndicNormalizer;
import org.carrot2.text.util.MutableCharArray;

public class HindiStemmerAdapter
implements IStemmer {
    final IndicNormalizer indicNormalizer = new IndicNormalizer();
    final HindiNormalizer hindiNormalizer = new HindiNormalizer();
    final HindiStemmer hindiStemmer = new HindiStemmer();
    private char[] buffer = new char[0];

    @Override
    public CharSequence stem(CharSequence charSequence) {
        if (charSequence.length() > this.buffer.length) {
            this.buffer = new char[charSequence.length()];
        }
        int n = 0;
        while (n < charSequence.length()) {
            this.buffer[n] = charSequence.charAt(n);
            ++n;
        }
        n = charSequence.length();
        n = this.indicNormalizer.normalize(this.buffer, n);
        n = this.hindiNormalizer.normalize(this.buffer, n);
        if (!this.equals(charSequence, this.buffer, n = this.hindiStemmer.stem(this.buffer, n))) {
            return new MutableCharArray(Arrays.copyOf(this.buffer, n));
        }
        return charSequence;
    }

    private boolean equals(CharSequence charSequence, char[] cArray, int n) {
        if (charSequence.length() != n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (charSequence.charAt(n2) != cArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

